package tech.checkhim.exceptions;

/**
 * Exception thrown when a phone number has an invalid format.
 * 
 * This occurs when the provided phone number doesn't meet the expected
 * format requirements (e.g., missing country code, invalid characters).
 */
public class InvalidFormatException extends CheckHimException {

    /**
     * Creates a new InvalidFormatException.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     */
    public InvalidFormatException(String message, int httpStatusCode) {
        super(message, "REJECTED_FORMAT", httpStatusCode);
    }

    /**
     * Creates a new InvalidFormatException with a cause.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     * @param cause The underlying cause
     */
    public InvalidFormatException(String message, int httpStatusCode, Throwable cause) {
        super(message, "REJECTED_FORMAT", httpStatusCode, cause);
    }
}