package tech.checkhim.exceptions;

/**
 * Exception thrown when a phone number verification fails due to network issues.
 * 
 * This typically occurs when the network operator forbids verification
 * or when the network is not supported for verification.
 */
public class NetworkRejectedException extends CheckHimException {

    /**
     * Creates a new NetworkRejectedException.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     */
    public NetworkRejectedException(String message, int httpStatusCode) {
        super(message, "REJECTED_NETWORK", httpStatusCode);
    }

    /**
     * Creates a new NetworkRejectedException with a cause.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     * @param cause The underlying cause
     */
    public NetworkRejectedException(String message, int httpStatusCode, Throwable cause) {
        super(message, "REJECTED_NETWORK", httpStatusCode, cause);
    }
}