package tech.checkhim.exceptions;

/**
 * Exception thrown when a phone number is missing the required country prefix.
 * 
 * This occurs when the phone number doesn't include the international
 * dialing code (e.g., +55 for Brazil, +1 for US).
 */
public class PrefixMissingException extends CheckHimException {

    /**
     * Creates a new PrefixMissingException.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     */
    public PrefixMissingException(String message, int httpStatusCode) {
        super(message, "REJECTED_PREFIX_MISSING", httpStatusCode);
    }

    /**
     * Creates a new PrefixMissingException with a cause.
     *
     * @param message The error message
     * @param httpStatusCode The HTTP status code
     * @param cause The underlying cause
     */
    public PrefixMissingException(String message, int httpStatusCode, Throwable cause) {
        super(message, "REJECTED_PREFIX_MISSING", httpStatusCode, cause);
    }
}