/*
 * Decompiled with CFR 0.152.
 */
package tech.checkhim.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VerificationRequest {
    @JsonProperty(value="number")
    @NotNull(message="Phone number cannot be null")
    @NotBlank(message="Phone number cannot be blank")
    private @NotNull(message="Phone number cannot be null") @NotBlank(message="Phone number cannot be blank") String number;
    @JsonProperty(value="type")
    private String type = "frontend";

    public VerificationRequest() {
    }

    private VerificationRequest(Builder builder) {
        this.number = builder.number;
        this.type = builder.type;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "VerificationRequest{number='" + this.number + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationRequest that = (VerificationRequest)o;
        if (!this.number.equals(that.number)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.number.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public static class Builder {
        private String number;
        private String type = "frontend";

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public VerificationRequest build() {
            if (this.number == null || this.number.trim().isEmpty()) {
                throw new IllegalArgumentException("Phone number is required and cannot be null or empty");
            }
            return new VerificationRequest(this);
        }
    }
}

