/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.arrow;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.spark.network.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;
import tech.mlsql.arrow.Utils;
import tech.mlsql.arrow.Utils$RedirectThread$;
import tech.mlsql.arrow.api.RedirectStreams;
import tech.mlsql.arrow.python.PythonWorkerFactory$Tool$;
import tech.mlsql.common.utils.log.Logging;

public final class Utils$
implements Logging {
    public static final Utils$ MODULE$;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;

    static {
        new Utils$();
    }

    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public <T> T tryWithSafeFinally(Function0<T> block, Function0<BoxedUnit> finallyBlock) {
        Throwable throwable;
        Object object;
        Object originalThrowable = null;
        try {
            object = block.apply();
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable;
            }
            catch (Throwable throwable3) {
                try {
                    finallyBlock.apply$mcV$sp();
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    if (throwable5 != null) {
                        Throwable throwable6 = throwable5;
                        if (throwable != null) {
                            Throwable throwable7 = throwable;
                            Throwable throwable8 = throwable6;
                            if (throwable7 == null ? throwable8 != null : !throwable7.equals(throwable8)) {
                                throwable.addSuppressed(throwable6);
                                this.logWarning((Function0<String>)new Serializable(throwable6){
                                    public static final long serialVersionUID = 0L;
                                    private final Throwable x5$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressing exception in finally: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x5$1.getMessage()}));
                                    }
                                    {
                                        this.x5$1 = x5$1;
                                    }
                                }, throwable6);
                                throw throwable;
                            }
                        }
                    }
                    throw throwable4;
                }
                throw throwable3;
            }
        }
        try {
            finallyBlock.apply$mcV$sp();
        }
        catch (Throwable throwable9) {
            Throwable throwable10 = throwable9;
            if (throwable10 != null) {
                Throwable throwable11 = throwable10;
                if (throwable != null) {
                    Throwable throwable12 = throwable;
                    Throwable throwable13 = throwable11;
                    if (throwable12 == null ? throwable13 != null : !throwable12.equals(throwable13)) {
                        throwable.addSuppressed(throwable11);
                        this.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */, throwable11);
                        throw throwable;
                    }
                }
            }
            throw throwable9;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public <R extends Closeable, T> T tryWithResource(Function0<R> createResource, Function1<R, T> f) {
        Object object;
        Closeable resource = (Closeable)createResource.apply();
        try {
            object = f.apply((Object)resource);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        resource.close();
        return (T)object;
    }

    public Option<String> getStderr(Process process, long timeoutMs) {
        boolean terminated = process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
        return terminated ? new Some((Object)Source$.MODULE$.fromInputStream(process.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n")) : None$.MODULE$;
    }

    public <T> T logUncaughtExceptions(Function0<T> f) {
        try {
            return (T)f.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uncaught exception in thread ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Thread.currentThread().getName()}));
                    }
                }, throwable3);
                throw throwable3;
            }
            throw throwable;
        }
    }

    public <T> Try<T> tryLog(Function0<T> f) {
        Throwable throwable2;
        block3: {
            Success success;
            try {
                Object res = f.apply();
                success = new Success(res);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable3;
                    throw (Throwable)controlThrowable;
                }
                if (throwable3 == null) break block3;
                Throwable throwable4 = throwable3;
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uncaught exception in thread ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Thread.currentThread().getName()}));
                    }
                }, throwable4);
                Failure failure = new Failure(throwable4);
                success = failure;
            }
            return success;
        }
        throw throwable2;
    }

    public boolean isFatalError(Throwable e) {
        Throwable throwable = e;
        Option option = NonFatal$.MODULE$.unapply(throwable);
        boolean bl = option.isEmpty() ? (throwable instanceof InterruptedException ? true : (throwable instanceof NotImplementedError ? true : (throwable instanceof ControlThrowable ? true : throwable instanceof LinkageError))) : true;
        boolean bl2 = !bl;
        return bl2;
    }

    public void deleteRecursively(File file) {
        if (file != null) {
            JavaUtils.deleteRecursively((File)file);
        }
    }

    public void redirectStream(Map<String, String> conf, InputStream stdout) {
        block4: {
            try {
                Option option = conf.get((Object)PythonWorkerFactory$Tool$.MODULE$.REDIRECT_IMPL());
                if (None$.MODULE$.equals(option)) {
                    new Utils.RedirectThread(stdout, System.err, "stdout reader  ", Utils$RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String clzz = (String)some.x();
                    RedirectStreams instance = (RedirectStreams)Class.forName(clzz).newInstance();
                    instance.setConf(conf);
                    instance.stdOut(stdout);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception exception) {
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Exception in redirecting streams";
                    }
                }, exception);
            }
        }
    }

    public void writeUTF(String str, DataOutputStream dataOut) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        dataOut.write(bytes);
    }

    private Utils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

