/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.arrow;

import java.util.List;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.SparkUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

public final class ArrowUtils$ {
    public static final ArrowUtils$ MODULE$;
    private final RootAllocator rootAllocator;

    static {
        new ArrowUtils$();
    }

    public RootAllocator rootAllocator() {
        return this.rootAllocator;
    }

    public ArrowType toArrowType(DataType dt, String timeZoneId) {
        return (ArrowType)SparkUtils$.MODULE$.isFixDecimal(dt).getOrElse((Function0)new Serializable(dt, timeZoneId){
            public static final long serialVersionUID = 0L;
            private final DataType dt$1;
            private final String timeZoneId$2;

            public final ArrowType apply() {
                block15: {
                    ArrowType.Bool bool;
                    block5: {
                        DataType dataType;
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block4: {
                                                                dataType = this.dt$1;
                                                                if (!BooleanType$.MODULE$.equals(dataType)) break block4;
                                                                bool = ArrowType.Bool.INSTANCE;
                                                                break block5;
                                                            }
                                                            if (!ByteType$.MODULE$.equals(dataType)) break block6;
                                                            bool = new ArrowType.Int(8, true);
                                                            break block5;
                                                        }
                                                        if (!ShortType$.MODULE$.equals(dataType)) break block7;
                                                        bool = new ArrowType.Int(16, true);
                                                        break block5;
                                                    }
                                                    if (!IntegerType$.MODULE$.equals(dataType)) break block8;
                                                    bool = new ArrowType.Int(32, true);
                                                    break block5;
                                                }
                                                if (!LongType$.MODULE$.equals(dataType)) break block9;
                                                bool = new ArrowType.Int(64, true);
                                                break block5;
                                            }
                                            if (!FloatType$.MODULE$.equals(dataType)) break block10;
                                            bool = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                                            break block5;
                                        }
                                        if (!DoubleType$.MODULE$.equals(dataType)) break block11;
                                        bool = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                                        break block5;
                                    }
                                    if (!StringType$.MODULE$.equals(dataType)) break block12;
                                    bool = ArrowType.Utf8.INSTANCE;
                                    break block5;
                                }
                                if (!BinaryType$.MODULE$.equals(dataType)) break block13;
                                bool = ArrowType.Binary.INSTANCE;
                                break block5;
                            }
                            if (!DateType$.MODULE$.equals(dataType)) break block14;
                            bool = new ArrowType.Date(DateUnit.DAY);
                            break block5;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType)) break block15;
                        if (this.timeZoneId$2 == null) {
                            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " must supply timeZoneId parameter"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TimestampType$.MODULE$.catalogString()})));
                        }
                        bool = new ArrowType.Timestamp(TimeUnit.MICROSECOND, this.timeZoneId$2);
                    }
                    return bool;
                }
                throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported data type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dt$1.catalogString()})));
            }
            {
                this.dt$1 = dt$1;
                this.timeZoneId$2 = timeZoneId$2;
            }
        });
    }

    public DataType fromArrowType(ArrowType dt) {
        block14: {
            BooleanType$ booleanType$;
            block3: {
                ArrowType arrowType;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    ArrowType.FloatingPoint floatingPoint;
                                    boolean bl;
                                    block8: {
                                        block7: {
                                            ArrowType.Int intVal;
                                            boolean bl2;
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            bl2 = false;
                                                            intVal = null;
                                                            bl = false;
                                                            floatingPoint = null;
                                                            arrowType = dt;
                                                            ArrowType.Bool bool = ArrowType.Bool.INSTANCE;
                                                            ArrowType arrowType2 = arrowType;
                                                            if (bool != null ? !bool.equals(arrowType2) : arrowType2 != null) break block2;
                                                            booleanType$ = BooleanType$.MODULE$;
                                                            break block3;
                                                        }
                                                        if (!(arrowType instanceof ArrowType.Int)) break block4;
                                                        bl2 = true;
                                                        intVal = (ArrowType.Int)arrowType;
                                                        if (!intVal.getIsSigned() || intVal.getBitWidth() != 8) break block4;
                                                        booleanType$ = ByteType$.MODULE$;
                                                        break block3;
                                                    }
                                                    if (!bl2 || !intVal.getIsSigned() || intVal.getBitWidth() != 16) break block5;
                                                    booleanType$ = ShortType$.MODULE$;
                                                    break block3;
                                                }
                                                if (!bl2 || !intVal.getIsSigned() || intVal.getBitWidth() != 32) break block6;
                                                booleanType$ = IntegerType$.MODULE$;
                                                break block3;
                                            }
                                            if (!bl2 || !intVal.getIsSigned() || intVal.getBitWidth() != 64) break block7;
                                            booleanType$ = LongType$.MODULE$;
                                            break block3;
                                        }
                                        if (!(arrowType instanceof ArrowType.FloatingPoint)) break block8;
                                        bl = true;
                                        floatingPoint = (ArrowType.FloatingPoint)arrowType;
                                        FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
                                        FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.SINGLE;
                                        if (floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision2) : floatingPointPrecision2 != null) break block8;
                                        booleanType$ = FloatType$.MODULE$;
                                        break block3;
                                    }
                                    if (!bl) break block9;
                                    FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
                                    FloatingPointPrecision floatingPointPrecision3 = FloatingPointPrecision.DOUBLE;
                                    if (floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision3) : floatingPointPrecision3 != null) break block9;
                                    booleanType$ = DoubleType$.MODULE$;
                                    break block3;
                                }
                                ArrowType.Utf8 utf8 = ArrowType.Utf8.INSTANCE;
                                ArrowType arrowType3 = arrowType;
                                if (utf8 != null ? !utf8.equals(arrowType3) : arrowType3 != null) break block10;
                                booleanType$ = StringType$.MODULE$;
                                break block3;
                            }
                            ArrowType.Binary binary = ArrowType.Binary.INSTANCE;
                            ArrowType arrowType4 = arrowType;
                            if (binary != null ? !binary.equals(arrowType4) : arrowType4 != null) break block11;
                            booleanType$ = BinaryType$.MODULE$;
                            break block3;
                        }
                        if (!(arrowType instanceof ArrowType.Decimal)) break block12;
                        ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
                        booleanType$ = new DecimalType(decimal.getPrecision(), decimal.getScale());
                        break block3;
                    }
                    if (!(arrowType instanceof ArrowType.Date)) break block13;
                    ArrowType.Date date = (ArrowType.Date)arrowType;
                    DateUnit dateUnit = date.getUnit();
                    DateUnit dateUnit2 = DateUnit.DAY;
                    if (dateUnit != null ? !dateUnit.equals(dateUnit2) : dateUnit2 != null) break block13;
                    booleanType$ = DateType$.MODULE$;
                    break block3;
                }
                if (!(arrowType instanceof ArrowType.Timestamp)) break block14;
                ArrowType.Timestamp timestamp = (ArrowType.Timestamp)arrowType;
                TimeUnit timeUnit = timestamp.getUnit();
                TimeUnit timeUnit2 = TimeUnit.MICROSECOND;
                if (timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null) break block14;
                booleanType$ = TimestampType$.MODULE$;
            }
            return booleanType$;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported data type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt})));
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId) {
        Field field;
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null);
            field = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Field[]{this.toArrowField("element", elementType, containsNull, timeZoneId)}))).asJava());
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null);
            field = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(timeZoneId){
                public static final long serialVersionUID = 0L;
                private final String timeZoneId$3;

                public final Field apply(StructField field) {
                    return ArrowUtils$.MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), this.timeZoneId$3);
                }
                {
                    this.timeZoneId$3 = timeZoneId$3;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class)))).toSeq()).asJava());
        } else {
            FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId), null);
            field = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava());
        }
        return field;
    }

    public DataType fromArrowField(Field field) {
        DataType dataType;
        ArrowType arrowType = field.getType();
        ArrowType.List list = ArrowType.List.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(list != null ? !list.equals(arrowType2) : arrowType2 != null)) {
            Field elementField = (Field)field.getChildren().get(0);
            DataType elementType = this.fromArrowField(elementField);
            dataType = new ArrayType(elementType, elementField.isNullable());
        } else {
            ArrowType.Struct struct = ArrowType.Struct.INSTANCE;
            ArrowType arrowType3 = arrowType;
            if (!(struct != null ? !struct.equals(arrowType3) : arrowType3 != null)) {
                Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(Field child) {
                        DataType dt = ArrowUtils$.MODULE$.fromArrowField(child);
                        return new StructField(child.getName(), dt, child.isNullable(), StructField$.MODULE$.apply$default$4());
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                dataType = StructType$.MODULE$.apply((Seq)fields);
            } else {
                dataType = this.fromArrowType(arrowType);
            }
        }
        return dataType;
    }

    public Schema toArrowSchema(StructType schema2, String timeZoneId) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema2.map((Function1)new Serializable(timeZoneId){
            public static final long serialVersionUID = 0L;
            private final String timeZoneId$1;

            public final Field apply(StructField field) {
                return ArrowUtils$.MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), this.timeZoneId$1);
            }
            {
                this.timeZoneId$1 = timeZoneId$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava());
    }

    public StructType fromArrowSchema(Schema schema2) {
        return StructType$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema2.getFields()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(Field field) {
                DataType dt = ArrowUtils$.MODULE$.fromArrowField(field);
                return new StructField(field.getName(), dt, field.isNullable(), StructField$.MODULE$.apply$default$4());
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    private ArrowUtils$() {
        MODULE$ = this;
        this.rootAllocator = new RootAllocator(Long.MAX_VALUE);
    }
}

