/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.arrow;

import java.io.Serializable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.SparkUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import tech.mlsql.arrow.ArrayWriter;
import tech.mlsql.arrow.ArrowFieldWriter;
import tech.mlsql.arrow.ArrowUtils$;
import tech.mlsql.arrow.ArrowWriter;
import tech.mlsql.arrow.BinaryWriter;
import tech.mlsql.arrow.BooleanWriter;
import tech.mlsql.arrow.ByteWriter;
import tech.mlsql.arrow.DateWriter;
import tech.mlsql.arrow.DecimalWriter;
import tech.mlsql.arrow.DoubleWriter;
import tech.mlsql.arrow.FloatWriter;
import tech.mlsql.arrow.IntegerWriter;
import tech.mlsql.arrow.LongWriter;
import tech.mlsql.arrow.ShortWriter;
import tech.mlsql.arrow.StringWriter;
import tech.mlsql.arrow.StructWriter;
import tech.mlsql.arrow.TimestampWriter;

public final class ArrowWriter$ {
    public static ArrowWriter$ MODULE$;

    static {
        new ArrowWriter$();
    }

    public ArrowWriter create(StructType schema, String timeZoneId) {
        Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema, timeZoneId);
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)ArrowUtils$.MODULE$.rootAllocator());
        return this.create(root);
    }

    public ArrowWriter create(VectorSchemaRoot root) {
        Buffer children = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(root.getFieldVectors()).asScala()).map((Function1 & Serializable & scala.Serializable)vector -> {
            vector.allocateNew();
            return MODULE$.createFieldWriter((ValueVector)vector);
        }, Buffer$.MODULE$.canBuildFrom());
        return new ArrowWriter(root, (ArrowFieldWriter[])children.toArray(ClassTag$.MODULE$.apply(ArrowFieldWriter.class)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private ArrowFieldWriter createFieldWriter(ValueVector vector) {
        void var2_29;
        Field field = vector.getField();
        Option<ArrowType.Decimal> fixDecimalOpt = SparkUtils$.MODULE$.isFixDecimal(ArrowUtils$.MODULE$.fromArrowField(field));
        Tuple2 tuple2 = new Tuple2(fixDecimalOpt, (Object)vector);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            ValueVector vector2 = (ValueVector)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                ArrowType.Decimal i = (ArrowType.Decimal)some.value();
                if (vector2 instanceof DecimalVector) {
                    DecimalVector decimalVector = (DecimalVector)vector2;
                    return new DecimalWriter(decimalVector, i.getPrecision(), i.getScale());
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Tuple2 tuple22 = new Tuple2((Object)ArrowUtils$.MODULE$.fromArrowField(field), (Object)vector);
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector3 = (ValueVector)tuple22._2();
            if (BooleanType$.MODULE$.equals(dataType) && vector3 instanceof BitVector) {
                BitVector bitVector = (BitVector)vector3;
                BooleanWriter booleanWriter = new BooleanWriter(bitVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector4 = (ValueVector)tuple22._2();
            if (ByteType$.MODULE$.equals(dataType) && vector4 instanceof TinyIntVector) {
                TinyIntVector tinyIntVector = (TinyIntVector)vector4;
                ByteWriter byteWriter = new ByteWriter(tinyIntVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector5 = (ValueVector)tuple22._2();
            if (ShortType$.MODULE$.equals(dataType) && vector5 instanceof SmallIntVector) {
                SmallIntVector smallIntVector = (SmallIntVector)vector5;
                ShortWriter shortWriter = new ShortWriter(smallIntVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector6 = (ValueVector)tuple22._2();
            if (IntegerType$.MODULE$.equals(dataType) && vector6 instanceof IntVector) {
                IntVector intVector = (IntVector)vector6;
                IntegerWriter integerWriter = new IntegerWriter(intVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector7 = (ValueVector)tuple22._2();
            if (LongType$.MODULE$.equals(dataType) && vector7 instanceof BigIntVector) {
                BigIntVector bigIntVector = (BigIntVector)vector7;
                LongWriter longWriter = new LongWriter(bigIntVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector8 = (ValueVector)tuple22._2();
            if (FloatType$.MODULE$.equals(dataType) && vector8 instanceof Float4Vector) {
                Float4Vector float4Vector = (Float4Vector)vector8;
                FloatWriter floatWriter = new FloatWriter(float4Vector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector9 = (ValueVector)tuple22._2();
            if (DoubleType$.MODULE$.equals(dataType) && vector9 instanceof Float8Vector) {
                Float8Vector float8Vector = (Float8Vector)vector9;
                DoubleWriter doubleWriter = new DoubleWriter(float8Vector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector10 = (ValueVector)tuple22._2();
            if (StringType$.MODULE$.equals(dataType) && vector10 instanceof VarCharVector) {
                VarCharVector varCharVector = (VarCharVector)vector10;
                StringWriter stringWriter = new StringWriter(varCharVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector11 = (ValueVector)tuple22._2();
            if (BinaryType$.MODULE$.equals(dataType) && vector11 instanceof VarBinaryVector) {
                VarBinaryVector varBinaryVector = (VarBinaryVector)vector11;
                BinaryWriter binaryWriter = new BinaryWriter(varBinaryVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector12 = (ValueVector)tuple22._2();
            if (DateType$.MODULE$.equals(dataType) && vector12 instanceof DateDayVector) {
                DateDayVector dateDayVector = (DateDayVector)vector12;
                DateWriter dateWriter = new DateWriter(dateDayVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector13 = (ValueVector)tuple22._2();
            if (TimestampType$.MODULE$.equals(dataType) && vector13 instanceof TimeStampMicroTZVector) {
                TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)vector13;
                TimestampWriter timestampWriter = new TimestampWriter(timeStampMicroTZVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector14 = (ValueVector)tuple22._2();
            if (dataType instanceof ArrayType && vector14 instanceof ListVector) {
                ListVector listVector = (ListVector)vector14;
                ArrowFieldWriter elementVector = this.createFieldWriter((ValueVector)listVector.getDataVector());
                ArrayWriter arrayWriter = new ArrayWriter(listVector, elementVector);
                return var2_29;
            }
        }
        if (tuple22 != null) {
            DataType dataType = (DataType)tuple22._1();
            ValueVector vector15 = (ValueVector)tuple22._2();
            if (dataType instanceof StructType && vector15 instanceof StructVector) {
                StructVector structVector = (StructVector)vector15;
                IndexedSeq children = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), structVector.size()).map((Function1 & Serializable & scala.Serializable)ordinal -> ArrowWriter$.MODULE$.createFieldWriter(structVector.getChildByOrdinal(BoxesRunTime.unboxToInt((Object)ordinal))), IndexedSeq$.MODULE$.canBuildFrom());
                StructWriter structWriter = new StructWriter(structVector, (ArrowFieldWriter[])children.toArray(ClassTag$.MODULE$.apply(ArrowFieldWriter.class)));
                return var2_29;
            }
        }
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        DataType dt = (DataType)tuple22._1();
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt.catalogString()).toString());
    }

    private ArrowWriter$() {
        MODULE$ = this;
    }
}

