/*
 * api.video Java API client
 * api.video is an API that encodes on the go to facilitate immediate playback, enhancing viewer streaming experiences across multiple devices and platforms. You can stream live or on-demand online videos within minutes.
 *
 * The version of the OpenAPI document: 1
 * Contact: ecosystem-team@api.video
 *
 * NOTE: This class is auto generated.
 * Do not edit the class manually.
 */

package video.api.client.api;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ApiException extends Exception {
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private String bodyMessage = null;
    private List<ApiProblem> problems;

    public ApiException() {
    }

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders,
            String responseBody) {
        super(message, throwable);

        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;

        Type typeOfHashMap = new TypeToken<Map<String, Object>>() {
        }.getType();
        Map<String, Object> parsedResponse = new Gson().fromJson(responseBody, typeOfHashMap);

        if (parsedResponse != null) {
            String details = null;
            try {
                if (parsedResponse.get("title") != null) {
                    details = (String) parsedResponse.get("title");
                } else if (parsedResponse.get("events") != null) {
                    details = (String) parsedResponse.get("events");
                }
            } catch (JsonSyntaxException ignored) {

            }

            if (StringUtils.isNotBlank(message) && details != null) {
                bodyMessage = message + ": " + details;
            } else if (details != null) {
                bodyMessage = details;
            } else {
                bodyMessage = message;
            }

            if (parsedResponse.containsKey("problems")) {
                List<Map<String, String>> problemsList = (List<Map<String, String>>) parsedResponse.get("problems");
                if (problemsList != null) {
                    this.problems = problemsList.stream().filter(Objects::nonNull)
                            .map(p -> new ApiProblem(p.get("type"), p.get("title"), p.get("name")))
                            .collect(Collectors.toList());
                }
            }
        }
    }

    @Override
    public String getMessage() {
        if (bodyMessage != null) {
            return bodyMessage;
        }
        return super.getMessage();
    }

    public List<ApiProblem> getProblems() {
        return this.problems;
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, (Throwable) null, code, responseHeaders, responseBody);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, null);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this((String) null, (Throwable) null, code, responseHeaders, responseBody);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    /**
     * Get the HTTP status code.
     *
     * @return HTTP status code
     */
    public int getCode() {
        return code;
    }

    /**
     * Get the HTTP response headers.
     *
     * @return A map of list of string
     */
    public Map<String, List<String>> getResponseHeaders() {
        return responseHeaders;
    }

    /**
     * Get the HTTP response body.
     *
     * @return Response body in the form of string
     */
    public String getResponseBody() {
        return responseBody;
    }

    public static class ApiProblem {
        private String type;
        private String title;
        private String name;

        public ApiProblem(String type, String title, String name) {
            this.type = type;
            this.title = title;
            this.name = name;
        }

        public String getType() {
            return type;
        }

        public String getTitle() {
            return title;
        }

        public String getName() {
            return name;
        }

        @Override
        public String toString() {
            return "ApiProblem{" + "type='" + type + '\'' + ", title='" + title + '\'' + ", name='" + name + '\'' + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
                return false;
            ApiProblem that = (ApiProblem) o;
            return Objects.equals(getType(), that.getType()) && Objects.equals(getTitle(), that.getTitle())
                    && Objects.equals(getName(), that.getName());
        }

    }
}