/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.net.URI;
import java.time.OffsetDateTime;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.UploadTokensApi;
import video.api.client.api.models.Page;
import video.api.client.api.models.PaginationLink;
import video.api.client.api.models.TokenCreatePayload;
import video.api.client.api.models.UploadToken;

@DisplayName(value="VideosDelegatedUploadApi")
public class UploadTokensApiTest
extends AbstractApiTest {
    private final UploadTokensApi api;

    public UploadTokensApiTest() {
        this.api = this.apiClientMock.uploadTokens();
    }

    @Nested
    @DisplayName(value="createToken")
    class createToken {
        private static final String PAYLOADS_PATH = "/payloads/uploadtokens/createToken/";

        createToken() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            UploadTokensApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> UploadTokensApiTest.this.api.createToken(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'tokenCreatePayload' when calling createToken");
            Assertions.assertThatNoException().isThrownBy(() -> UploadTokensApiTest.this.api.createToken(new TokenCreatePayload()));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            UploadTokensApiTest.this.answerOnAnyRequest(200, UploadTokensApiTest.this.readResourceFile("/payloads/uploadtokens/createToken/responses/200.json"));
            UploadToken res = UploadTokensApiTest.this.api.createToken(new TokenCreatePayload());
            Assertions.assertThat((String)res.getToken()).isEqualTo("to1tcmSFHeYY5KzyhOqVKMKb");
            Assertions.assertThat((Integer)res.getTtl()).isEqualTo(3600);
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            UploadTokensApiTest.this.answerOnAnyRequest(400, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> UploadTokensApiTest.this.api.createToken(new TokenCreatePayload())).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="getToken")
    class getToken {
        private static final String PAYLOADS_PATH = "/payloads/uploadtokens/getToken/";

        getToken() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            UploadTokensApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> UploadTokensApiTest.this.api.getToken(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'uploadToken' when calling getToken");
            Assertions.assertThatNoException().isThrownBy(() -> UploadTokensApiTest.this.api.getToken("to1tcmSFHeYY5KzyhOqVKMKb"));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            UploadTokensApiTest.this.answerOnAnyRequest(200, UploadTokensApiTest.this.readResourceFile("/payloads/uploadtokens/getToken/responses/200.json"));
            UploadToken res = UploadTokensApiTest.this.api.getToken("to1tcmSFHeYY5KzyhOqVKMKb");
            Assertions.assertThat((String)res.getToken()).isEqualTo("to1tcmSFHeYY5KzyhOqVKMKb");
            Assertions.assertThat((Integer)res.getTtl()).isEqualTo(0);
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            UploadTokensApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> UploadTokensApiTest.this.api.getToken("to1tcmSFHeYY5KzyhOqVKMKb")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="list")
    class list {
        private static final String PAYLOADS_PATH = "/payloads/uploadtokens/list/";

        list() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            UploadTokensApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> UploadTokensApiTest.this.api.list().execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            UploadTokensApiTest.this.answerOnAnyRequest(200, UploadTokensApiTest.this.readResourceFile("/payloads/uploadtokens/list/responses/200.json"));
            Page res = UploadTokensApiTest.this.api.list().execute();
            Assertions.assertThat((Integer)res.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)res.getPagesTotal()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getCurrentPageItems()).isEqualTo(2);
            Assertions.assertThat((List)res.getLinks()).containsExactlyInAnyOrder((Object[])new PaginationLink[]{new PaginationLink().rel("self").uri(URI.create("/upload-tokens?currentPage=1&pageSize=25")), new PaginationLink().rel("first").uri(URI.create("/upload-tokens?currentPage=1&pageSize=25")), new PaginationLink().rel("last").uri(URI.create("/upload-tokens?currentPage=1&pageSize=25"))});
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new UploadToken[]{new UploadToken().token("to37YfoPDRR2pcDKa6LsUE0M").ttl(Integer.valueOf(3600)).createdAt(OffsetDateTime.parse("2020-12-02T10:26:46Z")).expiresAt(OffsetDateTime.parse("2020-12-02T11:26:46Z")), new UploadToken().token("to1W3ZS9PdUBZWzzTEZr1B79").ttl(Integer.valueOf(0)).createdAt(OffsetDateTime.parse("2020-12-02T10:26:28Z")).expiresAt(null)});
        }
    }

    @Nested
    @DisplayName(value="deleteToken")
    class deleteToken {
        private static final String PAYLOADS_PATH = "/payloads/uploadtokens/deleteToken/";

        deleteToken() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            UploadTokensApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> UploadTokensApiTest.this.api.deleteToken(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'uploadToken' when calling deleteToken");
            Assertions.assertThatNoException().isThrownBy(() -> UploadTokensApiTest.this.api.deleteToken("to1tcmSFHeYY5KzyhOqVKMKb"));
        }

        @Test
        @DisplayName(value="204 response")
        public void responseWithStatus204Test() throws ApiException {
            UploadTokensApiTest.this.answerOnAnyRequest(204, "");
            UploadTokensApiTest.this.api.deleteToken("to1tcmSFHeYY5KzyhOqVKMKb");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            UploadTokensApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> UploadTokensApiTest.this.api.deleteToken("to1tcmSFHeYY5KzyhOqVKMKb")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }
}

