/*
 * Decompiled with CFR 0.152.
 */
package video.api.integration;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import video.api.client.ApiVideoClient;
import video.api.client.api.ApiException;
import video.api.client.api.models.Page;
import video.api.client.api.models.Webhook;
import video.api.client.api.models.WebhooksCreatePayload;

@DisplayName(value="Integration tests of api.webhooks() methods")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@EnabledIfEnvironmentVariable(named="INTEGRATION_TESTS_API_TOKEN", matches=".+")
public class WebhooksTest {
    private ApiVideoClient apiClient = new ApiVideoClient(System.getenv().get("INTEGRATION_TESTS_API_TOKEN"), ApiVideoClient.Environment.SANDBOX);
    private Webhook webhook;

    @Test
    @Order(value=1)
    @DisplayName(value="create a webhook")
    public void createWebhook() throws ApiException {
        this.webhook = this.apiClient.webhooks().create(new WebhooksCreatePayload().events(Collections.singletonList("video.encoding.quality.completed")).url("https://webhooks.test-java-api-client"));
        Assertions.assertThat((String)this.webhook.getWebhookId()).isNotNull();
    }

    @Test
    @Order(value=2)
    @DisplayName(value="list webhooks")
    public void listWebhooks() throws ApiException {
        Page webhooks = this.apiClient.webhooks().list().execute();
        Assertions.assertThat((List)webhooks.getItems()).hasSize(1);
        Assertions.assertThat((String)((Webhook)webhooks.getItems().get(0)).getWebhookId()).isEqualTo(this.webhook.getWebhookId());
        Assertions.assertThat((List)((Webhook)webhooks.getItems().get(0)).getEvents()).hasSize(1);
        Assertions.assertThat((String)((Webhook)webhooks.getItems().get(0)).getUrl()).isEqualTo("https://webhooks.test-java-api-client");
    }

    @Test
    @Order(value=3)
    @DisplayName(value="get webhook")
    public void getWebhook() throws ApiException {
        Webhook webhook = this.apiClient.webhooks().get(this.webhook.getWebhookId());
        Assertions.assertThat((String)webhook.getWebhookId()).isEqualTo(this.webhook.getWebhookId());
        Assertions.assertThat((List)webhook.getEvents()).hasSize(1);
        Assertions.assertThat((String)webhook.getUrl()).isEqualTo("https://webhooks.test-java-api-client");
    }

    @AfterAll
    public void deleteWebhook() throws ApiException {
        this.apiClient.webhooks().delete(this.webhook.getWebhookId());
    }
}

