/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.Quality;
import video.api.client.api.models.VideostatusEncodingMetadata;

public class VideostatusEncoding
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_PLAYABLE = "playable";
    @SerializedName(value="playable")
    private Boolean playable;
    public static final String SERIALIZED_NAME_QUALITIES = "qualities";
    @SerializedName(value="qualities")
    private List<Quality> qualities = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private VideostatusEncodingMetadata metadata;

    public VideostatusEncoding playable(Boolean playable) {
        this.playable = playable;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the video is playable or not.")
    public Boolean getPlayable() {
        return this.playable;
    }

    public void setPlayable(Boolean playable) {
        this.playable = playable;
    }

    public VideostatusEncoding qualities(List<Quality> qualities) {
        this.qualities = qualities;
        return this;
    }

    public VideostatusEncoding addQualitiesItem(Quality qualitiesItem) {
        if (this.qualities == null) {
            this.qualities = new ArrayList<Quality>();
        }
        this.qualities.add(qualitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Available qualities the video can be viewed in.")
    public List<Quality> getQualities() {
        return this.qualities;
    }

    public void setQualities(List<Quality> qualities) {
        this.qualities = qualities;
    }

    public VideostatusEncoding metadata(VideostatusEncodingMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideostatusEncodingMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(VideostatusEncodingMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideostatusEncoding videostatusEncoding = (VideostatusEncoding)o;
        return Objects.equals(this.playable, videostatusEncoding.playable) && Objects.equals(this.qualities, videostatusEncoding.qualities) && Objects.equals(this.metadata, videostatusEncoding.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.playable, this.qualities, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideostatusEncoding {\n");
        sb.append("    playable: ").append(this.toIndentedString(this.playable)).append("\n");
        sb.append("    qualities: ").append(this.toIndentedString(this.qualities)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

