/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public class VideoSessionSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_SESSION_ID = "sessionId";
    @SerializedName(value="sessionId")
    private String sessionId;
    public static final String SERIALIZED_NAME_LOADED_AT = "loadedAt";
    @SerializedName(value="loadedAt")
    private OffsetDateTime loadedAt;
    public static final String SERIALIZED_NAME_ENDED_AT = "endedAt";
    @SerializedName(value="endedAt")
    private OffsetDateTime endedAt;

    public VideoSessionSession sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="psEmFwGQUAXR2lFHj5nDOpy", value="The unique identifier for the session that you can use to track what happens during it.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public VideoSessionSession loadedAt(OffsetDateTime loadedAt) {
        this.loadedAt = loadedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the video session started, presented in ISO-8601 format.")
    public OffsetDateTime getLoadedAt() {
        return this.loadedAt;
    }

    public void setLoadedAt(OffsetDateTime loadedAt) {
        this.loadedAt = loadedAt;
    }

    public VideoSessionSession endedAt(OffsetDateTime endedAt) {
        this.endedAt = endedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the video session ended, presented in ISO-8601 format.")
    public OffsetDateTime getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(OffsetDateTime endedAt) {
        this.endedAt = endedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoSessionSession videoSessionSession = (VideoSessionSession)o;
        return Objects.equals(this.sessionId, videoSessionSession.sessionId) && Objects.equals(this.loadedAt, videoSessionSession.loadedAt) && Objects.equals(this.endedAt, videoSessionSession.endedAt);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.loadedAt, this.endedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoSessionSession {\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    loadedAt: ").append(this.toIndentedString(this.loadedAt)).append("\n");
        sb.append("    endedAt: ").append(this.toIndentedString(this.endedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

