/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.io.File;
import java.time.OffsetDateTime;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.PlayerThemesApi;
import video.api.client.api.models.Page;
import video.api.client.api.models.PlayerTheme;
import video.api.client.api.models.PlayerThemeCreationPayload;
import video.api.client.api.models.PlayerThemeUpdatePayload;

@DisplayName(value="PlayerThemeApi")
@Disabled
public class PlayerThemesApiTest
extends AbstractApiTest {
    private final PlayerThemesApi api;

    public PlayerThemesApiTest() {
        this.api = this.apiClientMock.playerThemes();
    }

    @Nested
    @DisplayName(value="uploadLogo")
    class uploadLogo {
        private static final String PAYLOADS_PATH = "/payloads/players/uploadLogo/";

        uploadLogo() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            PlayerThemesApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.uploadLogo(null, new File(""), "en")).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'playerId' when calling uploadLogo");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.uploadLogo("12", null, "en")).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'file' when calling uploadLogo");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.uploadLogo("12", new File(""), null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'link' when calling uploadLogo");
            Assertions.assertThatNoException().isThrownBy(() -> PlayerThemesApiTest.this.api.uploadLogo("pl14Db6oMJRH6SRVoOwORacK", new File(""), "file_example"));
        }

        @Test
        @DisplayName(value="201 response")
        public void responseWithStatus201Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(201, "");
            PlayerTheme res = PlayerThemesApiTest.this.api.uploadLogo("pl14Db6oMJRH6SRVoOwORacK", new File(""), "file_example");
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(400, PlayerThemesApiTest.this.readResourceFile("/payloads/players/uploadLogo/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.uploadLogo("pl14Db6oMJRH6SRVoOwORacK", new File(""), "file_example")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("Only ['jpg', 'JPG', 'jpeg', 'JPEG', 'png', 'PNG'] extensions are supported.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(404, PlayerThemesApiTest.this.readResourceFile("/payloads/players/uploadLogo/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.uploadLogo("pl14Db6oMJRH6SRVoOwORacK", new File(""), "file_example")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="create")
    class create {
        private static final String PAYLOADS_PATH = "/payloads/players/create/";

        create() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            PlayerThemesApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.create(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'playerCreationPayload' when calling create");
            Assertions.assertThatNoException().isThrownBy(() -> PlayerThemesApiTest.this.api.create(new PlayerThemeCreationPayload()));
        }

        @Test
        @DisplayName(value="201 response")
        public void responseWithStatus201Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(201, PlayerThemesApiTest.this.readResourceFile("/payloads/players/create/responses/201.json"));
            PlayerTheme res = PlayerThemesApiTest.this.api.create(new PlayerThemeCreationPayload());
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl45d5vFFGrfdsdsd156dGhh");
            Assertions.assertThat((OffsetDateTime)res.getCreatedAt()).isEqualTo("2020-01-13T10:09:17+00:00");
            Assertions.assertThat((OffsetDateTime)res.getUpdatedAt()).isEqualTo("2020-01-13T10:09:17+00:00");
            Assertions.assertThat((Integer)res.getShapeRadius()).isEqualTo(3);
            Assertions.assertThat((String)res.getShapeAspect()).isEqualTo("flat");
            Assertions.assertThat((String)res.getShapeBackgroundTop()).isEqualTo("rgba(50, 50, 50, .7)");
            Assertions.assertThat((String)res.getShapeBackgroundBottom()).isEqualTo("rgba(50, 50, 50, .8)");
            Assertions.assertThat((String)res.getText()).isEqualTo("rgba(255, 255, 255, .95)");
            Assertions.assertThat((String)res.getLink()).isEqualTo("rgba(255, 0, 0, .95)");
            Assertions.assertThat((String)res.getLinkHover()).isEqualTo("rgba(255, 255, 255, .75)");
            Assertions.assertThat((String)res.getLinkActive()).isEqualTo("rgba(255, 0, 0, .75)");
            Assertions.assertThat((String)res.getTrackPlayed()).isEqualTo("rgba(255, 255, 255, .95)");
            Assertions.assertThat((String)res.getTrackUnplayed()).isEqualTo("rgba(255, 255, 255, .1)");
            Assertions.assertThat((String)res.getTrackBackground()).isEqualTo("rgba(0, 0, 0, 0)");
            Assertions.assertThat((String)res.getBackgroundTop()).isEqualTo("rgba(72, 4, 45, 1)");
            Assertions.assertThat((String)res.getBackgroundBottom()).isEqualTo("rgba(94, 95, 89, 1)");
            Assertions.assertThat((String)res.getBackgroundText()).isEqualTo("rgba(255, 255, 255, .95)");
            Assertions.assertThat((Boolean)res.getEnableApi()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getEnableControls()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getForceAutoplay()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getHideTitle()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getForceLoop()).isEqualTo(false);
        }
    }

    @Nested
    @DisplayName(value="update")
    class update {
        private static final String PAYLOADS_PATH = "/payloads/players/update/";

        update() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            PlayerThemesApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.update(null, new PlayerThemeUpdatePayload())).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'playerId' when calling update");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.update("pl45d5vFFGrfdsdsd156dGhh", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'playerUpdatePayload' when calling update");
            Assertions.assertThatNoException().isThrownBy(() -> PlayerThemesApiTest.this.api.update("pl45d5vFFGrfdsdsd156dGhh", new PlayerThemeUpdatePayload()));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(200, PlayerThemesApiTest.this.readResourceFile("/payloads/players/update/responses/200.json"));
            PlayerTheme res = PlayerThemesApiTest.this.api.update("pl45d5vFFGrfdsdsd156dGhh", new PlayerThemeUpdatePayload());
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl45d5vFFGrfdsdsd156dGhh");
            Assertions.assertThat((OffsetDateTime)res.getCreatedAt()).isEqualTo("2020-01-13T10:09:17+00:00");
            Assertions.assertThat((OffsetDateTime)res.getUpdatedAt()).isEqualTo("2020-01-13T11:12:14+00:00");
            Assertions.assertThat((Integer)res.getShapeRadius()).isEqualTo(3);
            Assertions.assertThat((String)res.getShapeAspect()).isEqualTo("flat");
            Assertions.assertThat((String)res.getShapeBackgroundTop()).isEqualTo("rgba(50, 50, 50, .7)");
            Assertions.assertThat((String)res.getShapeBackgroundBottom()).isEqualTo("rgba(50, 50, 50, .8)");
            Assertions.assertThat((String)res.getText()).isEqualTo("rgba(255, 255, 255, .95)");
            Assertions.assertThat((String)res.getLink()).isEqualTo("rgba(255, 0, 0, .95)");
            Assertions.assertThat((String)res.getLinkHover()).isEqualTo("rgba(255, 255, 255, .75)");
            Assertions.assertThat((String)res.getLinkActive()).isEqualTo("rgba(255, 0, 0, .75)");
            Assertions.assertThat((String)res.getTrackPlayed()).isEqualTo("rgba(255, 255, 255, .95)");
            Assertions.assertThat((String)res.getTrackUnplayed()).isEqualTo("rgba(255, 255, 255, .1)");
            Assertions.assertThat((String)res.getTrackBackground()).isEqualTo("rgba(0, 0, 0, 0)");
            Assertions.assertThat((String)res.getBackgroundTop()).isEqualTo("rgba(72, 4, 45, 1)");
            Assertions.assertThat((String)res.getBackgroundBottom()).isEqualTo("rgba(94, 95, 89, 1)");
            Assertions.assertThat((String)res.getBackgroundText()).isEqualTo("rgba(255, 255, 255, .95)");
            Assertions.assertThat((Boolean)res.getEnableApi()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getEnableControls()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getForceAutoplay()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getHideTitle()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getForceLoop()).isEqualTo(false);
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(404, PlayerThemesApiTest.this.readResourceFile("/payloads/players/update/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.update("pl45d5vFFGrfdsdsd156dGhh", new PlayerThemeUpdatePayload())).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="get")
    class get {
        private static final String PAYLOADS_PATH = "/payloads/players/get/";

        get() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            PlayerThemesApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.get(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'playerId' when calling get");
            Assertions.assertThatNoException().isThrownBy(() -> PlayerThemesApiTest.this.api.get("pl45d5vFFGrfdsdsd156dGhh"));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(200, PlayerThemesApiTest.this.readResourceFile("/payloads/players/get/responses/200.json"));
            PlayerTheme res = PlayerThemesApiTest.this.api.get("pl45d5vFFGrfdsdsd156dGhh");
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl45d5vFFGrfdsdsd156dGhh");
            Assertions.assertThat((OffsetDateTime)res.getCreatedAt()).isEqualTo("2020-01-13T10:09:17+00:00");
            Assertions.assertThat((OffsetDateTime)res.getUpdatedAt()).isEqualTo("2020-01-13T11:12:14+00:00");
            Assertions.assertThat((Integer)res.getShapeRadius()).isEqualTo(3);
            Assertions.assertThat((String)res.getShapeAspect()).isEqualTo("flat");
            Assertions.assertThat((String)res.getShapeBackgroundTop()).isEqualTo("rgba(50, 50, 50, .7)");
            Assertions.assertThat((String)res.getShapeBackgroundBottom()).isEqualTo("rgba(50, 50, 50, .8)");
            Assertions.assertThat((String)res.getText()).isEqualTo("rgba(255, 255, 255, .95)");
            Assertions.assertThat((String)res.getLink()).isEqualTo("rgba(255, 0, 0, .95)");
            Assertions.assertThat((String)res.getLinkHover()).isEqualTo("rgba(255, 255, 255, .75)");
            Assertions.assertThat((String)res.getLinkActive()).isEqualTo("rgba(255, 0, 0, .75)");
            Assertions.assertThat((String)res.getTrackPlayed()).isEqualTo("rgba(255, 255, 255, .95)");
            Assertions.assertThat((String)res.getTrackUnplayed()).isEqualTo("rgba(255, 255, 255, .1)");
            Assertions.assertThat((String)res.getTrackBackground()).isEqualTo("rgba(0, 0, 0, 0)");
            Assertions.assertThat((String)res.getBackgroundTop()).isEqualTo("rgba(72, 4, 45, 1)");
            Assertions.assertThat((String)res.getBackgroundBottom()).isEqualTo("rgba(94, 95, 89, 1)");
            Assertions.assertThat((String)res.getBackgroundText()).isEqualTo("rgba(255, 255, 255, .95)");
            Assertions.assertThat((Boolean)res.getEnableApi()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getEnableControls()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getForceAutoplay()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getHideTitle()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getForceLoop()).isEqualTo(false);
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(404, PlayerThemesApiTest.this.readResourceFile("/payloads/players/get/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.get("pl45d5vFFGrfdsdsd156dGhh")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="list")
    class list {
        private static final String PAYLOADS_PATH = "/payloads/players/list/";

        list() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            PlayerThemesApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> PlayerThemesApiTest.this.api.list().execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(200, PlayerThemesApiTest.this.readResourceFile("/payloads/players/list/responses/200.json"));
            Page res = PlayerThemesApiTest.this.api.list().execute();
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(400, PlayerThemesApiTest.this.readResourceFile("/payloads/players/list/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.list().execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("This parameter is out of the allowed range of values.");
        }
    }

    @Nested
    @DisplayName(value="deleteLogo")
    class deleteLogo {
        private static final String PAYLOADS_PATH = "/payloads/players/deleteLogo/";

        deleteLogo() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            PlayerThemesApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> PlayerThemesApiTest.this.api.deleteLogo("pl14Db6oMJRH6SRVoOwORacK"));
            Assertions.assertThatNoException().isThrownBy(() -> PlayerThemesApiTest.this.api.deleteLogo(null));
        }

        @Test
        @DisplayName(value="204 response")
        public void responseWithStatus204Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(204, "");
            PlayerThemesApiTest.this.api.deleteLogo("pl14Db6oMJRH6SRVoOwORacK");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(404, PlayerThemesApiTest.this.readResourceFile("/payloads/players/deleteLogo/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.deleteLogo("pl14Db6oMJRH6SRVoOwORacK")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="delete")
    class delete {
        private static final String PAYLOADS_PATH = "/payloads/players/delete/";

        delete() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            PlayerThemesApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> PlayerThemesApiTest.this.api.delete("pl45d5vFFGrfdsdsd156dGhh"));
            Assertions.assertThatNoException().isThrownBy(() -> PlayerThemesApiTest.this.api.delete(null));
        }

        @Test
        @DisplayName(value="204 response")
        public void responseWithStatus204Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(204, "");
            PlayerThemesApiTest.this.api.delete("pl45d5vFFGrfdsdsd156dGhh");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            PlayerThemesApiTest.this.answerOnAnyRequest(404, PlayerThemesApiTest.this.readResourceFile("/payloads/players/delete/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PlayerThemesApiTest.this.api.delete("pl45d5vFFGrfdsdsd156dGhh")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }
}

