/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.AccountQuota;

public class Account
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_QUOTA = "quota";
    @SerializedName(value="quota")
    private AccountQuota quota;
    public static final String SERIALIZED_NAME_FEATURES = "features";
    @SerializedName(value="features")
    private List<String> features = null;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private String environment;

    public Account quota(AccountQuota quota) {
        this.quota = quota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccountQuota getQuota() {
        return this.quota;
    }

    public void setQuota(AccountQuota quota) {
        this.quota = quota;
    }

    public Account features(List<String> features) {
        this.features = features;
        return this;
    }

    public Account addFeaturesItem(String featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList<String>();
        }
        this.features.add(featuresItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"app.dynamic_metadata, app.event_log\"]", value="Deprecated. What features are enabled for your account. Choices include: app.dynamic_metadata - the ability to dynamically tag videos to better segment and understand your audiences, app.event_log - the ability to create and retrieve a log detailing how your videos were interacted with, player.white_label - the ability to customise your player, stats.player_events - the ability to see statistics about how your player is being used, transcode.mp4_support - the ability to reformat content into mp4 using the H264 codec.")
    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public Account environment(String environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. Whether you are using your production or sandbox API key will impact what environment is displayed here, as well as stats and features information. If you use your sandbox key, the environment is \"sandbox.\" If you use your production key, the environment is \"production.\"")
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.quota, account.quota) && Objects.equals(this.features, account.features) && Objects.equals(this.environment, account.environment);
    }

    public int hashCode() {
        return Objects.hash(this.quota, this.features, this.environment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

