/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import video.api.client.api.models.Pagination;
import video.api.client.api.models.PaginationLink;

public class Page<T>
implements Iterable<Page<T>> {
    private List<T> items;
    private Integer currentPage;
    private Integer pageSize;
    private Integer pagesTotal;
    private Integer itemsTotal;
    private Integer currentPageItems;
    private List<PaginationLink> links;
    private Supplier<Page<T>> getNextPage;
    private Page<T> that;

    public Page(List<T> items, Pagination pagination, Supplier<Page<T>> getNextPage) {
        this.items = items;
        if (pagination != null) {
            this.currentPage = pagination.getCurrentPage();
            this.pageSize = pagination.getPageSize();
            this.pagesTotal = pagination.getPagesTotal();
            this.itemsTotal = pagination.getItemsTotal();
            this.currentPageItems = pagination.getCurrentPageItems();
            this.links = pagination.getLinks();
            this.getNextPage = getNextPage;
            this.that = this;
        }
    }

    public List<T> getItems() {
        return this.items;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getPagesTotal() {
        return this.pagesTotal;
    }

    public Integer getItemsTotal() {
        return this.itemsTotal;
    }

    public Integer getCurrentPageItems() {
        return this.currentPageItems;
    }

    public List<PaginationLink> getLinks() {
        return this.links;
    }

    private Supplier<Page<T>> getGetNextPage() {
        return this.getNextPage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Page<> {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    currentPage: ").append(this.toIndentedString(this.currentPage)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    itemsTotal: ").append(this.toIndentedString(this.itemsTotal)).append("\n");
        sb.append("    currentPageItems: ").append(this.toIndentedString(this.currentPageItems)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Override
    public Iterator<Page<T>> iterator() {
        return new Iterator<Page<T>>(){
            private boolean first = true;

            @Override
            public boolean hasNext() {
                return this.first || Page.this.currentPage < Page.this.pagesTotal;
            }

            @Override
            public Page<T> next() {
                if (this.first) {
                    this.first = false;
                    return Page.this.that;
                }
                Page next = (Page)Page.this.getNextPage.get();
                Page.this.items = next.getItems();
                Page.this.currentPage = next.getCurrentPage();
                Page.this.pageSize = next.getPageSize();
                Page.this.pagesTotal = next.getPagesTotal();
                Page.this.itemsTotal = next.getItemsTotal();
                Page.this.currentPageItems = next.getCurrentPageItems();
                Page.this.links = next.getLinks();
                Page.this.getNextPage = next.getGetNextPage();
                return Page.this.that;
            }
        };
    }
}

