/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Environment;
import video.api.client.api.models.LiveStream;
import video.api.client.api.models.LiveStreamCreationPayload;
import video.api.client.api.models.LiveStreamListResponse;
import video.api.client.api.models.LiveStreamUpdatePayload;
import video.api.client.api.models.Page;

public class LiveStreamsApi {
    private ApiClient localVarApiClient;

    public LiveStreamsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public LiveStreamsApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public LiveStreamsApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public LiveStreamsApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call createCall(LiveStreamCreationPayload liveStreamCreationPayload, ApiCallback _callback) throws ApiException {
        LiveStreamCreationPayload localVarPostBody = liveStreamCreationPayload;
        String localVarPath = "/live-streams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(LiveStreamCreationPayload liveStreamCreationPayload, ApiCallback _callback) throws ApiException {
        if (liveStreamCreationPayload == null) {
            throw new ApiException("Missing the required parameter 'liveStreamCreationPayload' when calling create");
        }
        if (liveStreamCreationPayload.getName() == null) {
            throw new ApiException("Missing the required parameter 'liveStreamCreationPayload.name' when calling create");
        }
        Call localVarCall = this.createCall(liveStreamCreationPayload, _callback);
        return localVarCall;
    }

    public LiveStream create(LiveStreamCreationPayload liveStreamCreationPayload) throws ApiException {
        ApiResponse<LiveStream> localVarResp = this.createWithHttpInfo(liveStreamCreationPayload);
        return localVarResp.getData();
    }

    public ApiResponse<LiveStream> createWithHttpInfo(LiveStreamCreationPayload liveStreamCreationPayload) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(liveStreamCreationPayload, null);
        Type localVarReturnType = new TypeToken<LiveStream>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCall(String liveStreamId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/live-streams/{liveStreamId}".replaceAll("\\{liveStreamId\\}", this.localVarApiClient.escapeString(liveStreamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getValidateBeforeCall(String liveStreamId, ApiCallback _callback) throws ApiException {
        if (liveStreamId == null) {
            throw new ApiException("Missing the required parameter 'liveStreamId' when calling get");
        }
        Call localVarCall = this.getCall(liveStreamId, _callback);
        return localVarCall;
    }

    public LiveStream get(String liveStreamId) throws ApiException {
        ApiResponse<LiveStream> localVarResp = this.getWithHttpInfo(liveStreamId);
        return localVarResp.getData();
    }

    public ApiResponse<LiveStream> getWithHttpInfo(String liveStreamId) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(liveStreamId, null);
        Type localVarReturnType = new TypeToken<LiveStream>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateCall(String liveStreamId, LiveStreamUpdatePayload liveStreamUpdatePayload, ApiCallback _callback) throws ApiException {
        LiveStreamUpdatePayload localVarPostBody = liveStreamUpdatePayload;
        String localVarPath = "/live-streams/{liveStreamId}".replaceAll("\\{liveStreamId\\}", this.localVarApiClient.escapeString(liveStreamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateValidateBeforeCall(String liveStreamId, LiveStreamUpdatePayload liveStreamUpdatePayload, ApiCallback _callback) throws ApiException {
        if (liveStreamId == null) {
            throw new ApiException("Missing the required parameter 'liveStreamId' when calling update");
        }
        if (liveStreamUpdatePayload == null) {
            throw new ApiException("Missing the required parameter 'liveStreamUpdatePayload' when calling update");
        }
        Call localVarCall = this.updateCall(liveStreamId, liveStreamUpdatePayload, _callback);
        return localVarCall;
    }

    public LiveStream update(String liveStreamId, LiveStreamUpdatePayload liveStreamUpdatePayload) throws ApiException {
        ApiResponse<LiveStream> localVarResp = this.updateWithHttpInfo(liveStreamId, liveStreamUpdatePayload);
        return localVarResp.getData();
    }

    public ApiResponse<LiveStream> updateWithHttpInfo(String liveStreamId, LiveStreamUpdatePayload liveStreamUpdatePayload) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(liveStreamId, liveStreamUpdatePayload, null);
        Type localVarReturnType = new TypeToken<LiveStream>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCall(String liveStreamId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/live-streams/{liveStreamId}".replaceAll("\\{liveStreamId\\}", this.localVarApiClient.escapeString(liveStreamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String liveStreamId, ApiCallback _callback) throws ApiException {
        if (liveStreamId == null) {
            throw new ApiException("Missing the required parameter 'liveStreamId' when calling delete");
        }
        Call localVarCall = this.deleteCall(liveStreamId, _callback);
        return localVarCall;
    }

    public void delete(String liveStreamId) throws ApiException {
        this.deleteWithHttpInfo(liveStreamId);
    }

    public ApiResponse<Void> deleteWithHttpInfo(String liveStreamId) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(liveStreamId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call listCall(String streamKey, String name, String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/live-streams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (streamKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("streamKey", streamKey));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listValidateBeforeCall(String streamKey, String name, String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(streamKey, name, sortBy, sortOrder, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<LiveStreamListResponse> listWithHttpInfo(String streamKey, String name, String sortBy, String sortOrder, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(streamKey, name, sortBy, sortOrder, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<LiveStreamListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public APIlistRequest list() {
        return new APIlistRequest();
    }

    private Call uploadThumbnailCall(String liveStreamId, File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/live-streams/{liveStreamId}/thumbnail".replaceAll("\\{liveStreamId\\}", this.localVarApiClient.escapeString(liveStreamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadThumbnailValidateBeforeCall(String liveStreamId, File file, ApiCallback _callback) throws ApiException {
        if (liveStreamId == null) {
            throw new ApiException("Missing the required parameter 'liveStreamId' when calling uploadThumbnail");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadThumbnail");
        }
        Call localVarCall = this.uploadThumbnailCall(liveStreamId, file, _callback);
        return localVarCall;
    }

    public LiveStream uploadThumbnail(String liveStreamId, File file) throws ApiException {
        ApiResponse<LiveStream> localVarResp = this.uploadThumbnailWithHttpInfo(liveStreamId, file);
        return localVarResp.getData();
    }

    public ApiResponse<LiveStream> uploadThumbnailWithHttpInfo(String liveStreamId, File file) throws ApiException {
        Call localVarCall = this.uploadThumbnailValidateBeforeCall(liveStreamId, file, null);
        Type localVarReturnType = new TypeToken<LiveStream>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteThumbnailCall(String liveStreamId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/live-streams/{liveStreamId}/thumbnail".replaceAll("\\{liveStreamId\\}", this.localVarApiClient.escapeString(liveStreamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteThumbnailValidateBeforeCall(String liveStreamId, ApiCallback _callback) throws ApiException {
        if (liveStreamId == null) {
            throw new ApiException("Missing the required parameter 'liveStreamId' when calling deleteThumbnail");
        }
        Call localVarCall = this.deleteThumbnailCall(liveStreamId, _callback);
        return localVarCall;
    }

    public LiveStream deleteThumbnail(String liveStreamId) throws ApiException {
        ApiResponse<LiveStream> localVarResp = this.deleteThumbnailWithHttpInfo(liveStreamId);
        return localVarResp.getData();
    }

    public ApiResponse<LiveStream> deleteThumbnailWithHttpInfo(String liveStreamId) throws ApiException {
        Call localVarCall = this.deleteThumbnailValidateBeforeCall(liveStreamId, null);
        Type localVarReturnType = new TypeToken<LiveStream>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public class APIlistRequest {
        private String streamKey;
        private String name;
        private String sortBy;
        private String sortOrder;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistRequest() {
        }

        public APIlistRequest streamKey(String streamKey) {
            this.streamKey = streamKey;
            return this;
        }

        public APIlistRequest name(String name) {
            this.name = name;
            return this;
        }

        public APIlistRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIlistRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIlistRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return LiveStreamsApi.this.listCall(this.streamKey, this.name, this.sortBy, this.sortOrder, this.currentPage, this.pageSize, _callback);
        }

        public Page<LiveStream> execute() throws ApiException {
            ApiResponse localVarResp = LiveStreamsApi.this.listWithHttpInfo(this.streamKey, this.name, this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
            return new Page<LiveStream>(((LiveStreamListResponse)localVarResp.getData()).getData(), ((LiveStreamListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistRequest copy() {
            APIlistRequest copy = new APIlistRequest();
            copy.streamKey(this.streamKey);
            copy.name(this.name);
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<LiveStreamListResponse> executeWithHttpInfo() throws ApiException {
            return LiveStreamsApi.this.listWithHttpInfo(this.streamKey, this.name, this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
        }
    }
}

