/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public class VideoWatermark
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TOP = "top";
    @SerializedName(value="top")
    private String top;
    public static final String SERIALIZED_NAME_LEFT = "left";
    @SerializedName(value="left")
    private String left;
    public static final String SERIALIZED_NAME_BOTTOM = "bottom";
    @SerializedName(value="bottom")
    private String bottom;
    public static final String SERIALIZED_NAME_RIGHT = "right";
    @SerializedName(value="right")
    private String right;
    public static final String SERIALIZED_NAME_WIDTH = "width";
    @SerializedName(value="width")
    private String width;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private String height;
    public static final String SERIALIZED_NAME_OPACITY = "opacity";
    @SerializedName(value="opacity")
    private String opacity;

    public VideoWatermark id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="watermark_1BWr2L5MTQwxGkuxKjzh6i", value="id of the watermark")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public VideoWatermark top(String top) {
        this.top = top;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10px", value="Distance expressed in px or % between the top-border of the video and the watermark-image.")
    public String getTop() {
        return this.top;
    }

    public void setTop(String top) {
        this.top = top;
    }

    public VideoWatermark left(String left) {
        this.left = left;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10px", value="Distance expressed in px or % between the left-border of the video and the watermark-image.")
    public String getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public VideoWatermark bottom(String bottom) {
        this.bottom = bottom;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10px", value="Distance expressed in px or % between the bottom-border of the video and the watermark-image.")
    public String getBottom() {
        return this.bottom;
    }

    public void setBottom(String bottom) {
        this.bottom = bottom;
    }

    public VideoWatermark right(String right) {
        this.right = right;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10px", value="Distance expressed in px or % between the right-border of the video and the watermark-image.")
    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public VideoWatermark width(String width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="initial", value="Width of the watermark-image relative to the video if expressed in %. Otherwise a fixed width. NOTE: To keep intrinsic watermark-image width use initial")
    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public VideoWatermark height(String height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="initial", value="Width of the watermark-image relative to the video if expressed in %. Otherwise a fixed height. NOTE: To keep intrinsic watermark-image height use initial")
    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public VideoWatermark opacity(String opacity) {
        this.opacity = opacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="70%", value="Opacity expressed in % only to specify the degree of the watermark-image transparency with the video.")
    public String getOpacity() {
        return this.opacity;
    }

    public void setOpacity(String opacity) {
        this.opacity = opacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoWatermark videoWatermark = (VideoWatermark)o;
        return Objects.equals(this.id, videoWatermark.id) && Objects.equals(this.top, videoWatermark.top) && Objects.equals(this.left, videoWatermark.left) && Objects.equals(this.bottom, videoWatermark.bottom) && Objects.equals(this.right, videoWatermark.right) && Objects.equals(this.width, videoWatermark.width) && Objects.equals(this.height, videoWatermark.height) && Objects.equals(this.opacity, videoWatermark.opacity);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.top, this.left, this.bottom, this.right, this.width, this.height, this.opacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoWatermark {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    bottom: ").append(this.toIndentedString(this.bottom)).append("\n");
        sb.append("    right: ").append(this.toIndentedString(this.right)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

