/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.io.File;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.WatermarksApi;
import video.api.client.api.models.Watermark;

@DisplayName(value="WatermarksApi")
public class WatermarksApiTest
extends AbstractApiTest {
    private final WatermarksApi api;

    public WatermarksApiTest() {
        this.api = this.apiClientMock.watermarks();
    }

    @Nested
    @DisplayName(value="upload")
    class upload {
        private static final String PAYLOADS_PATH = "/payloads/watermarks/upload/";

        upload() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            WatermarksApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> WatermarksApiTest.this.api.upload(new File("")));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WatermarksApiTest.this.api.upload(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'file' when calling upload");
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            WatermarksApiTest.this.answerOnAnyRequest(200, WatermarksApiTest.this.readResourceFile("/payloads/watermarks/upload/responses/200.json"));
            Watermark res = WatermarksApiTest.this.api.upload(new File("/path/to/file"));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            WatermarksApiTest.this.answerOnAnyRequest(400, WatermarksApiTest.this.readResourceFile("/payloads/watermarks/upload/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WatermarksApiTest.this.api.upload(new File("/path/to/file"))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("Only [jpeg, jpg, JPG, JPEG, png, PNG] extensions are supported.");
        }
    }

    @Nested
    @DisplayName(value="list")
    class list {
        private static final String PAYLOADS_PATH = "/payloads/watermarks/list/";

        list() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            WatermarksApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> WatermarksApiTest.this.api.list().execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            WatermarksApiTest.this.answerOnAnyRequest(200, WatermarksApiTest.this.readResourceFile("/payloads/watermarks/list/responses/200.json"));
            WatermarksApiTest.this.api.list().sortBy("createdAt").sortOrder("asc").execute();
        }
    }

    @Nested
    @DisplayName(value="delete")
    class delete {
        private static final String PAYLOADS_PATH = "/payloads/watermarks/delete/";

        delete() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            WatermarksApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> WatermarksApiTest.this.api.delete("watermark_1BWr2L5MTQwxGkuxKjzh6i"));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WatermarksApiTest.this.api.delete(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'watermarkId' when calling delete");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            WatermarksApiTest.this.answerOnAnyRequest(404, WatermarksApiTest.this.readResourceFile("/payloads/watermarks/delete/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WatermarksApiTest.this.api.delete("watermark_1BWr2L5MTQwxGkuxKjzh6i")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }
}

