/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Environment;
import video.api.client.api.models.Page;
import video.api.client.api.models.Webhook;
import video.api.client.api.models.WebhooksCreationPayload;
import video.api.client.api.models.WebhooksListResponse;

public class WebhooksApi {
    private ApiClient localVarApiClient;

    public WebhooksApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public WebhooksApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public WebhooksApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public WebhooksApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call createCall(WebhooksCreationPayload webhooksCreationPayload, ApiCallback _callback) throws ApiException {
        WebhooksCreationPayload localVarPostBody = webhooksCreationPayload;
        String localVarPath = "/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call createValidateBeforeCall(WebhooksCreationPayload webhooksCreationPayload, ApiCallback _callback) throws ApiException {
        if (webhooksCreationPayload == null) {
            throw new ApiException("Missing the required parameter 'webhooksCreationPayload' when calling create");
        }
        if (webhooksCreationPayload.getEvents() == null) {
            throw new ApiException("Missing the required parameter 'webhooksCreationPayload.events' when calling create");
        }
        if (webhooksCreationPayload.getUrl() == null) {
            throw new ApiException("Missing the required parameter 'webhooksCreationPayload.url' when calling create");
        }
        Call localVarCall = this.createCall(webhooksCreationPayload, _callback);
        return localVarCall;
    }

    public Webhook create(WebhooksCreationPayload webhooksCreationPayload) throws ApiException {
        ApiResponse<Webhook> localVarResp = this.createWithHttpInfo(webhooksCreationPayload);
        return localVarResp.getData();
    }

    public ApiResponse<Webhook> createWithHttpInfo(WebhooksCreationPayload webhooksCreationPayload) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(webhooksCreationPayload, null);
        Type localVarReturnType = new TypeToken<Webhook>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAsync(WebhooksCreationPayload webhooksCreationPayload, ApiCallback<Webhook> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(webhooksCreationPayload, _callback);
        Type localVarReturnType = new TypeToken<Webhook>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getCall(String webhookId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call getValidateBeforeCall(String webhookId, ApiCallback _callback) throws ApiException {
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling get");
        }
        Call localVarCall = this.getCall(webhookId, _callback);
        return localVarCall;
    }

    public Webhook get(String webhookId) throws ApiException {
        ApiResponse<Webhook> localVarResp = this.getWithHttpInfo(webhookId);
        return localVarResp.getData();
    }

    public ApiResponse<Webhook> getWithHttpInfo(String webhookId) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(webhookId, null);
        Type localVarReturnType = new TypeToken<Webhook>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAsync(String webhookId, ApiCallback<Webhook> _callback) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(webhookId, _callback);
        Type localVarReturnType = new TypeToken<Webhook>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call deleteCall(String webhookId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call deleteValidateBeforeCall(String webhookId, ApiCallback _callback) throws ApiException {
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling delete");
        }
        Call localVarCall = this.deleteCall(webhookId, _callback);
        return localVarCall;
    }

    public void delete(String webhookId) throws ApiException {
        this.deleteWithHttpInfo(webhookId);
    }

    public ApiResponse<Void> deleteWithHttpInfo(String webhookId) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(webhookId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAsync(String webhookId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(webhookId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listCall(String events, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (events != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("events", events));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call listValidateBeforeCall(String events, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(events, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<WebhooksListResponse> listWithHttpInfo(String events, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(events, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<WebhooksListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAsync(String events, Integer currentPage, Integer pageSize, ApiCallback<WebhooksListResponse> _callback) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(events, currentPage, pageSize, _callback);
        Type localVarReturnType = new TypeToken<WebhooksListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRequest list() {
        return new APIlistRequest();
    }

    public class APIlistRequest {
        private String events;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistRequest() {
        }

        public APIlistRequest events(String events) {
            this.events = events;
            return this;
        }

        public APIlistRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WebhooksApi.this.listCall(this.events, this.currentPage, this.pageSize, _callback);
        }

        public Page<Webhook> execute() throws ApiException {
            ApiResponse localVarResp = WebhooksApi.this.listWithHttpInfo(this.events, this.currentPage, this.pageSize);
            return new Page<Webhook>(((WebhooksListResponse)localVarResp.getData()).getData(), ((WebhooksListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistRequest copy() {
            APIlistRequest copy = new APIlistRequest();
            copy.events(this.events);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<WebhooksListResponse> executeWithHttpInfo() throws ApiException {
            return WebhooksApi.this.listWithHttpInfo(this.events, this.currentPage, this.pageSize);
        }

        public Call executeAsync(final ApiCallback<Page<Webhook>> _callback) throws ApiException {
            ApiCallback<WebhooksListResponse> apiCallback = new ApiCallback<WebhooksListResponse>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onFailure(e, statusCode, responseHeaders);
                }

                @Override
                public void onSuccess(WebhooksListResponse result, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onSuccess(new Page<Webhook>(result.getData(), result.getPagination(), () -> {
                        try {
                            return APIlistRequest.this.copy().currentPage((APIlistRequest.this.currentPage == null ? 1 : APIlistRequest.this.currentPage) + 1).execute();
                        }
                        catch (ApiException e) {
                            throw new RuntimeException(e);
                        }
                    }), statusCode, responseHeaders);
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    _callback.onUploadProgress(bytesWritten, contentLength, done);
                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    _callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            return WebhooksApi.this.listAsync(this.events, this.currentPage, this.pageSize, apiCallback);
        }
    }
}

