/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.Metadata;

public class VideoSessionSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_SESSION_ID = "sessionId";
    @SerializedName(value="sessionId")
    private String sessionId;
    public static final String SERIALIZED_NAME_LOADED_AT = "loadedAt";
    @SerializedName(value="loadedAt")
    private OffsetDateTime loadedAt;
    public static final String SERIALIZED_NAME_ENDED_AT = "endedAt";
    @SerializedName(value="endedAt")
    private OffsetDateTime endedAt;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private List<Metadata> metadata = null;

    public VideoSessionSession sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="psEmFwGQUAXR2lFHj5nDOpy", value="The unique identifier for the session that you can use to track what happens during it.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public VideoSessionSession loadedAt(OffsetDateTime loadedAt) {
        this.loadedAt = loadedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-06-24T11:45:01.109Z", value="When the video session started, presented in ISO-8601 format.")
    public OffsetDateTime getLoadedAt() {
        return this.loadedAt;
    }

    public void setLoadedAt(OffsetDateTime loadedAt) {
        this.loadedAt = loadedAt;
    }

    public VideoSessionSession endedAt(OffsetDateTime endedAt) {
        this.endedAt = endedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-06-24T12:45:01.109Z", value="When the video session ended, presented in ISO-8601 format.")
    public OffsetDateTime getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(OffsetDateTime endedAt) {
        this.endedAt = endedAt;
    }

    public VideoSessionSession metadata(List<Metadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public VideoSessionSession addMetadataItem(Metadata metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<Metadata>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"key\": \"Author\", \"value\": \"John Doe\"}]", value="A list of key value pairs that you use to provide metadata for your video. These pairs can be made dynamic, allowing you to segment your audience. You can also just use the pairs as another way to tag and categorize your videos.")
    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Metadata> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoSessionSession videoSessionSession = (VideoSessionSession)o;
        return Objects.equals(this.sessionId, videoSessionSession.sessionId) && Objects.equals(this.loadedAt, videoSessionSession.loadedAt) && Objects.equals(this.endedAt, videoSessionSession.endedAt) && Objects.equals(this.metadata, videoSessionSession.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.loadedAt, this.endedAt, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoSessionSession {\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    loadedAt: ").append(this.toIndentedString(this.loadedAt)).append("\n");
        sb.append("    endedAt: ").append(this.toIndentedString(this.endedAt)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

