/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Environment;
import video.api.client.api.models.Page;
import video.api.client.api.models.TokenCreationPayload;
import video.api.client.api.models.TokenListResponse;
import video.api.client.api.models.UploadToken;

public class UploadTokensApi {
    private ApiClient localVarApiClient;

    public UploadTokensApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public UploadTokensApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public UploadTokensApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public UploadTokensApi(Environment environment) {
        this.localVarApiClient = new ApiClient(environment.basePath);
    }

    public UploadTokensApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public UploadTokensApi(String apiKey, Environment environment) {
        this.localVarApiClient = new ApiClient(apiKey, environment.basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call createTokenCall(TokenCreationPayload tokenCreationPayload, ApiCallback _callback) throws ApiException {
        TokenCreationPayload localVarPostBody = tokenCreationPayload;
        String localVarPath = "/upload-tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call createTokenValidateBeforeCall(TokenCreationPayload tokenCreationPayload, ApiCallback _callback) throws ApiException {
        if (tokenCreationPayload == null) {
            throw new ApiException("Missing the required parameter 'tokenCreationPayload' when calling createToken");
        }
        Call localVarCall = this.createTokenCall(tokenCreationPayload, _callback);
        return localVarCall;
    }

    public UploadToken createToken(TokenCreationPayload tokenCreationPayload) throws ApiException {
        ApiResponse<UploadToken> localVarResp = this.createTokenWithHttpInfo(tokenCreationPayload);
        return localVarResp.getData();
    }

    public ApiResponse<UploadToken> createTokenWithHttpInfo(TokenCreationPayload tokenCreationPayload) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(tokenCreationPayload, null);
        Type localVarReturnType = new TypeToken<UploadToken>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTokenAsync(TokenCreationPayload tokenCreationPayload, ApiCallback<UploadToken> _callback) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(tokenCreationPayload, _callback);
        Type localVarReturnType = new TypeToken<UploadToken>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getTokenCall(String uploadToken, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/upload-tokens/{uploadToken}".replaceAll("\\{uploadToken\\}", this.localVarApiClient.escapeString(uploadToken.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call getTokenValidateBeforeCall(String uploadToken, ApiCallback _callback) throws ApiException {
        if (uploadToken == null) {
            throw new ApiException("Missing the required parameter 'uploadToken' when calling getToken");
        }
        Call localVarCall = this.getTokenCall(uploadToken, _callback);
        return localVarCall;
    }

    public UploadToken getToken(String uploadToken) throws ApiException {
        ApiResponse<UploadToken> localVarResp = this.getTokenWithHttpInfo(uploadToken);
        return localVarResp.getData();
    }

    public ApiResponse<UploadToken> getTokenWithHttpInfo(String uploadToken) throws ApiException {
        Call localVarCall = this.getTokenValidateBeforeCall(uploadToken, null);
        Type localVarReturnType = new TypeToken<UploadToken>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTokenAsync(String uploadToken, ApiCallback<UploadToken> _callback) throws ApiException {
        Call localVarCall = this.getTokenValidateBeforeCall(uploadToken, _callback);
        Type localVarReturnType = new TypeToken<UploadToken>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call deleteTokenCall(String uploadToken, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/upload-tokens/{uploadToken}".replaceAll("\\{uploadToken\\}", this.localVarApiClient.escapeString(uploadToken.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call deleteTokenValidateBeforeCall(String uploadToken, ApiCallback _callback) throws ApiException {
        if (uploadToken == null) {
            throw new ApiException("Missing the required parameter 'uploadToken' when calling deleteToken");
        }
        Call localVarCall = this.deleteTokenCall(uploadToken, _callback);
        return localVarCall;
    }

    public void deleteToken(String uploadToken) throws ApiException {
        this.deleteTokenWithHttpInfo(uploadToken);
    }

    public ApiResponse<Void> deleteTokenWithHttpInfo(String uploadToken) throws ApiException {
        Call localVarCall = this.deleteTokenValidateBeforeCall(uploadToken, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTokenAsync(String uploadToken, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTokenValidateBeforeCall(uploadToken, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/upload-tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call listValidateBeforeCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(sortBy, sortOrder, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<TokenListResponse> listWithHttpInfo(String sortBy, String sortOrder, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(sortBy, sortOrder, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<TokenListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAsync(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback<TokenListResponse> _callback) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(sortBy, sortOrder, currentPage, pageSize, _callback);
        Type localVarReturnType = new TypeToken<TokenListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRequest list() {
        return new APIlistRequest();
    }

    public class APIlistRequest {
        private String sortBy;
        private String sortOrder;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistRequest() {
        }

        public APIlistRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIlistRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIlistRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UploadTokensApi.this.listCall(this.sortBy, this.sortOrder, this.currentPage, this.pageSize, _callback);
        }

        public Page<UploadToken> execute() throws ApiException {
            ApiResponse localVarResp = UploadTokensApi.this.listWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
            return new Page<UploadToken>(((TokenListResponse)localVarResp.getData()).getData(), ((TokenListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistRequest copy() {
            APIlistRequest copy = new APIlistRequest();
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<TokenListResponse> executeWithHttpInfo() throws ApiException {
            return UploadTokensApi.this.listWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
        }

        public Call executeAsync(final ApiCallback<Page<UploadToken>> _callback) throws ApiException {
            ApiCallback<TokenListResponse> apiCallback = new ApiCallback<TokenListResponse>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onFailure(e, statusCode, responseHeaders);
                }

                @Override
                public void onSuccess(TokenListResponse result, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onSuccess(new Page<UploadToken>(result.getData(), result.getPagination(), () -> {
                        try {
                            return APIlistRequest.this.copy().currentPage((APIlistRequest.this.currentPage == null ? 1 : APIlistRequest.this.currentPage) + 1).execute();
                        }
                        catch (ApiException e) {
                            throw new RuntimeException(e);
                        }
                    }), statusCode, responseHeaders);
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    _callback.onUploadProgress(bytesWritten, contentLength, done);
                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    _callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            return UploadTokensApi.this.listAsync(this.sortBy, this.sortOrder, this.currentPage, this.pageSize, apiCallback);
        }
    }
}

