/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.common.truth.Truth;
import java.time.LocalDate;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.AnalyticsApi;
import video.api.client.api.models.AnalyticsData;
import video.api.client.api.models.Page;

@DisplayName(value="AnalyticsApi")
public class AnalyticsApiTest
extends AbstractApiTest {
    private final AnalyticsApi api;

    public AnalyticsApiTest() {
        this.api = new AnalyticsApi(this.apiClientMock.getHttpClient());
    }

    @Nested
    @DisplayName(value="getVideosPlays")
    class getVideosPlays {
        private static final String PAYLOADS_PATH = "/payloads/analytics/getVideosPlays/";

        getVideosPlays() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            AnalyticsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getVideosPlays(LocalDate.parse("2023-04-01"), null).execute()).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'dimension' when calling getVideosPlays");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getVideosPlays(null, "videoId").execute()).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'from' when calling getVideosPlays");
            Assertions.assertThatNoException().isThrownBy(() -> AnalyticsApiTest.this.api.getVideosPlays(LocalDate.parse("2023-04-01"), "videoId").execute());
        }

        @Test
        @DisplayName(value="200 response by videoId")
        public void responseWithStatusByVideoId200Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(200, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getVideosPlays/responses/200-0.json"));
            Page res = AnalyticsApiTest.this.api.getVideosPlays(LocalDate.parse("2023-04-01"), "videoId").execute();
            AnalyticsData expected1 = new AnalyticsData().value("vi3q7HxhApxRF1c8F8r6VeaI");
            expected1.setPlays(Integer.valueOf(100));
            AnalyticsData expected2 = new AnalyticsData().value("vi3q7HxhApxRF1c8F8r6VeaF");
            expected2.setPlays(Integer.valueOf(10));
            AnalyticsData expected3 = new AnalyticsData().value("vi3q7HxhApxRF1c8F8r6VeaH");
            expected3.setPlays(Integer.valueOf(1));
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new AnalyticsData[]{expected1, expected2, expected3});
        }

        @Test
        @DisplayName(value="200 response by country")
        public void responseWithStatusByCountry200Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(200, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getVideosPlays/responses/200-1.json"));
            Page res = AnalyticsApiTest.this.api.getVideosPlays(LocalDate.parse("2023-04-01"), "country").execute();
            AnalyticsData expected1 = new AnalyticsData().value("france");
            expected1.setPlays(Integer.valueOf(100));
            AnalyticsData expected2 = new AnalyticsData().value("united states");
            expected2.setPlays(Integer.valueOf(10));
            AnalyticsData expected3 = new AnalyticsData().value("spain");
            expected3.setPlays(Integer.valueOf(1));
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new AnalyticsData[]{expected1, expected2, expected3});
        }

        @Test
        @DisplayName(value="200 response by emittedAt")
        public void responseWithStatusByEmittedAt200Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(200, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getVideosPlays/responses/200-2.json"));
            Page res = AnalyticsApiTest.this.api.getVideosPlays(LocalDate.parse("2023-04-01"), "emittedAt").execute();
            AnalyticsData expected1 = new AnalyticsData().value("2023-06-10T10:00:00.000Z");
            expected1.setPlays(Integer.valueOf(100));
            AnalyticsData expected2 = new AnalyticsData().value("2023-06-10T11:00:00.000Z");
            expected2.setPlays(Integer.valueOf(10));
            AnalyticsData expected3 = new AnalyticsData().value("2023-06-10T12:00:00.000Z");
            expected3.setPlays(Integer.valueOf(1));
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new AnalyticsData[]{expected1, expected2, expected3});
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400ForUnknownDimensionTest() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(400, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getVideosPlays/responses/400-2.json"));
            ApiException e = (ApiException)org.junit.jupiter.api.Assertions.assertThrows(ApiException.class, () -> AnalyticsApiTest.this.api.getVideosPlays(LocalDate.parse("2023-04-01"), "unknownDimension").execute());
            Truth.assertThat((Integer)e.getCode()).isEqualTo((Object)400);
            Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"A query parameter is invalid.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(404, "");
            ApiException e = (ApiException)org.junit.jupiter.api.Assertions.assertThrows(ApiException.class, () -> AnalyticsApiTest.this.api.getVideosPlays(LocalDate.parse("2023-04-01"), "country").execute());
            Truth.assertThat((Integer)e.getCode()).isEqualTo((Object)404);
            Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"");
        }
    }

    @Nested
    @DisplayName(value="getLiveStreamsPlays")
    class getLiveStreamsPlays {
        private static final String PAYLOADS_PATH = "/payloads/analytics/getLiveStreamsPlays/";

        getLiveStreamsPlays() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            AnalyticsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getLiveStreamsPlays(LocalDate.parse("2023-04-01"), null).execute()).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'dimension' when calling getLiveStreamsPlays");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getLiveStreamsPlays(null, "liveStreamId").execute()).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'from' when calling getLiveStreamsPlays");
            Assertions.assertThatNoException().isThrownBy(() -> AnalyticsApiTest.this.api.getLiveStreamsPlays(LocalDate.parse("2023-04-01"), "liveStreamId").execute());
        }

        @Test
        @DisplayName(value="200 response by liveStreamId")
        public void responseWithStatusByLiveStreamId200Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(200, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getLiveStreamsPlays/responses/200-0.json"));
            Page res = AnalyticsApiTest.this.api.getLiveStreamsPlays(LocalDate.parse("2023-04-01"), "liveStreamId").execute();
            AnalyticsData expected1 = new AnalyticsData().value("li3q7HxhApxRF1c8F8r6VeaI");
            expected1.setPlays(Integer.valueOf(100));
            AnalyticsData expected2 = new AnalyticsData().value("li3q7HxhApxRF1c8F8r6VeaB");
            expected2.setPlays(Integer.valueOf(10));
            AnalyticsData expected3 = new AnalyticsData().value("li3q7HxhApxRF1c8F8r6VeaD");
            expected3.setPlays(Integer.valueOf(1));
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new AnalyticsData[]{expected1, expected2, expected3});
        }

        @Test
        @DisplayName(value="200 response by country")
        public void responseWithStatusByCountry200Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(200, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getLiveStreamsPlays/responses/200-1.json"));
            Page res = AnalyticsApiTest.this.api.getLiveStreamsPlays(LocalDate.parse("2023-04-01"), "country").execute();
            AnalyticsData expected1 = new AnalyticsData().value("france");
            expected1.setPlays(Integer.valueOf(100));
            AnalyticsData expected2 = new AnalyticsData().value("united states");
            expected2.setPlays(Integer.valueOf(10));
            AnalyticsData expected3 = new AnalyticsData().value("spain");
            expected3.setPlays(Integer.valueOf(1));
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new AnalyticsData[]{expected1, expected2, expected3});
        }

        @Test
        @DisplayName(value="200 response by emittedAt")
        public void responseWithStatusByEmittedAt200Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(200, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getLiveStreamsPlays/responses/200-2.json"));
            Page res = AnalyticsApiTest.this.api.getLiveStreamsPlays(LocalDate.parse("2023-04-01"), "emittedAt").execute();
            AnalyticsData expected1 = new AnalyticsData().value("2023-06-10T10:00:00.000Z");
            expected1.setPlays(Integer.valueOf(100));
            AnalyticsData expected2 = new AnalyticsData().value("2023-06-10T11:00:00.000Z");
            expected2.setPlays(Integer.valueOf(10));
            AnalyticsData expected3 = new AnalyticsData().value("2023-06-10T12:00:00.000Z");
            expected3.setPlays(Integer.valueOf(1));
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new AnalyticsData[]{expected1, expected2, expected3});
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400ForUnknownDimensionTest() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(400, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getLiveStreamsPlays/responses/400-2.json"));
            ApiException e = (ApiException)org.junit.jupiter.api.Assertions.assertThrows(ApiException.class, () -> AnalyticsApiTest.this.api.getLiveStreamsPlays(LocalDate.parse("2023-04-01"), "unknownDimension").execute());
            Truth.assertThat((Integer)e.getCode()).isEqualTo((Object)400);
            Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"A query parameter is invalid.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(404, "");
            ApiException e = (ApiException)org.junit.jupiter.api.Assertions.assertThrows(ApiException.class, () -> AnalyticsApiTest.this.api.getLiveStreamsPlays(LocalDate.parse("2023-04-01"), "country").execute());
            Truth.assertThat((Integer)e.getCode()).isEqualTo((Object)404);
            Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"");
        }
    }
}

