/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.io.File;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.LiveStreamsApi;
import video.api.client.api.models.LiveStream;
import video.api.client.api.models.LiveStreamAssets;
import video.api.client.api.models.LiveStreamCreationPayload;
import video.api.client.api.models.LiveStreamUpdatePayload;
import video.api.client.api.models.Page;
import video.api.client.api.models.PaginationLink;
import video.api.client.api.models.RestreamsResponseObject;

@DisplayName(value="LiveStreamsApi")
public class LiveStreamsApiTest
extends AbstractApiTest {
    private final LiveStreamsApi api;

    public LiveStreamsApiTest() {
        this.api = this.apiClientMock.liveStreams();
    }

    @Nested
    @DisplayName(value="uploadThumbnail")
    class uploadThumbnail {
        private static final String PAYLOADS_PATH = "/payloads/livestreams/uploadThumbnail/";

        uploadThumbnail() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            LiveStreamsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.uploadThumbnail(null, new File(""))).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'liveStreamId' when calling uploadThumbnail");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.uploadThumbnail("12", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'file' when calling uploadThumbnail");
            Assertions.assertThatNoException().isThrownBy(() -> LiveStreamsApiTest.this.api.uploadThumbnail("vi4k0jvEUuaTdRAEjQ4Jfrgz", new File("")));
        }

        @Test
        @DisplayName(value="201 response")
        public void responseWithStatus201Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(201, "");
            LiveStream res = LiveStreamsApiTest.this.api.uploadThumbnail("vi4k0jvEUuaTdRAEjQ4Jfrgz", new File(""));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(400, LiveStreamsApiTest.this.readResourceFile("/payloads/livestreams/uploadThumbnail/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.uploadThumbnail("vi4k0jvEUuaTdRAEjQ4Jfrgz", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("Only [jpeg, jpg, JPG, JPEG] extensions are supported.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(404, LiveStreamsApiTest.this.readResourceFile("/payloads/livestreams/uploadThumbnail/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.uploadThumbnail("vi4k0jvEUuaTdRAEjQ4Jfrgz", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="create")
    class create {
        private static final String PAYLOADS_PATH = "/payloads/livestreams/create/";

        create() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            LiveStreamsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.create(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'liveStreamCreationPayload' when calling create");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.create(new LiveStreamCreationPayload())).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'liveStreamCreationPayload.name' when calling create");
            Assertions.assertThatNoException().isThrownBy(() -> LiveStreamsApiTest.this.api.create(new LiveStreamCreationPayload().name("name")));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(200, LiveStreamsApiTest.this.readResourceFile("/payloads/livestreams/create/responses/200.json"));
            LiveStream res = LiveStreamsApiTest.this.api.create(new LiveStreamCreationPayload().name("name"));
            Assertions.assertThat((String)res.getLiveStreamId()).isEqualTo("li4pqNqGUkhKfWcBGpZVLRY5");
            Assertions.assertThat((String)res.getStreamKey()).isEqualTo("cc1b4df0-d1c5-4064-a8f9-9f0368385135");
            Assertions.assertThat((String)res.getName()).isEqualTo("Live From New York");
            Assertions.assertThat((Boolean)res.getBroadcasting()).isEqualTo(false);
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new LiveStreamAssets().iframe("<iframe src=\"https://embed.api.video/live/li4pqNqGUkhKfWcBGpZVLRY5\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/live/li4pqNqGUkhKfWcBGpZVLRY5")).hls(URI.create("https://live.api.video/li4pqNqGUkhKfWcBGpZVLRY5.m3u8")).thumbnail(URI.create("https://live.api.video/li4pqNqGUkhKfWcBGpZVLRY5/thumbnail.jpg")));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(400, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.create(new LiveStreamCreationPayload().name("name"))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="update")
    class update {
        private static final String PAYLOADS_PATH = "/payloads/livestreams/update/";

        update() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            LiveStreamsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.update("li400mYKSgQ6xs7taUeSaEKr", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'liveStreamUpdatePayload' when calling update");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.update(null, new LiveStreamUpdatePayload())).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'liveStreamId' when calling update");
            Assertions.assertThatNoException().isThrownBy(() -> LiveStreamsApiTest.this.api.update("li400mYKSgQ6xs7taUeSaEKr", new LiveStreamUpdatePayload()));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(200, LiveStreamsApiTest.this.readResourceFile("/payloads/livestreams/update/responses/200.json"));
            LiveStream res = LiveStreamsApiTest.this.api.update("li4pqNqGUkhKfWcBGpZVLRY5", new LiveStreamUpdatePayload());
            Assertions.assertThat((String)res.getLiveStreamId()).isEqualTo("li4pqNqGUkhKfWcBGpZVLRY5");
            Assertions.assertThat((String)res.getStreamKey()).isEqualTo("cc1b4df0-d1c5-4064-a8f9-9f0368385135");
            Assertions.assertThat((String)res.getName()).isEqualTo("Live From New York");
            Assertions.assertThat((Boolean)res.getBroadcasting()).isEqualTo(false);
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new LiveStreamAssets().iframe("<iframe src=\"https://embed.api.video/live/li4pqNqGUkhKfWcBGpZVLRY5\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/live/li4pqNqGUkhKfWcBGpZVLRY5")).hls(URI.create("https://live.api.video/li4pqNqGUkhKfWcBGpZVLRY5.m3u8")).thumbnail(URI.create("https://live.api.video/li4pqNqGUkhKfWcBGpZVLRY5/thumbnail.jpg")));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(400, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.update("li400mYKSgQ6xs7taUeSaEKr", new LiveStreamUpdatePayload())).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="get")
    class get {
        private static final String PAYLOADS_PATH = "/payloads/livestreams/get/";

        get() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            LiveStreamsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.get(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'liveStreamId' when calling get");
            Assertions.assertThatNoException().isThrownBy(() -> LiveStreamsApiTest.this.api.get("li400mYKSgQ6xs7taUeSaEKr"));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(200, LiveStreamsApiTest.this.readResourceFile("/payloads/livestreams/get/responses/200.json"));
            LiveStream res = LiveStreamsApiTest.this.api.get("li4pqNqGUkhKfWcBGpZVLRY5");
            Assertions.assertThat((String)res.getLiveStreamId()).isEqualTo("li4pqNqGUkhKfWcBGpZVLRY5");
            Assertions.assertThat((String)res.getStreamKey()).isEqualTo("cc1b4df0-d1c5-4064-a8f9-9f0368385135");
            Assertions.assertThat((String)res.getName()).isEqualTo("Live From New York");
            Assertions.assertThat((Boolean)res.getBroadcasting()).isEqualTo(false);
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new LiveStreamAssets().iframe("<iframe src=\"https://embed.api.video/live/li4pqNqGUkhKfWcBGpZVLRY5\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/live/li4pqNqGUkhKfWcBGpZVLRY5")).hls(URI.create("https://live.api.video/li4pqNqGUkhKfWcBGpZVLRY5.m3u8")).thumbnail(URI.create("https://live.api.video/li4pqNqGUkhKfWcBGpZVLRY5/thumbnail.jpg")));
        }
    }

    @Nested
    @DisplayName(value="list")
    class list {
        private static final String PAYLOADS_PATH = "/payloads/livestreams/list/";

        list() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            LiveStreamsApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> LiveStreamsApiTest.this.api.list().execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(200, LiveStreamsApiTest.this.readResourceFile("/payloads/livestreams/list/responses/200.json"));
            Page res = LiveStreamsApiTest.this.api.list().execute();
            Assertions.assertThat((Integer)res.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)res.getPagesTotal()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getCurrentPageItems()).isEqualTo(19);
            Assertions.assertThat((List)res.getLinks()).containsExactlyInAnyOrder((Object[])new PaginationLink[]{new PaginationLink().rel("self").uri(URI.create("/live-streams?currentPage=1&pageSize=25")), new PaginationLink().rel("first").uri(URI.create("/live-streams?currentPage=1&pageSize=25")), new PaginationLink().rel("last").uri(URI.create("/live-streams?currentPage=1&pageSize=25"))});
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new LiveStream[]{new LiveStream().updatedAt(OffsetDateTime.parse("2020-03-09T13:19:43Z")).createdAt(OffsetDateTime.parse("2020-01-31T10:17:47Z")).liveStreamId("li400mYKSgQ6xs7taUeSaEKr").streamKey("30087931-229e-42cf-b5f9-e91bcc1f7332").name("Live Stream From the browser").broadcasting(Boolean.valueOf(false))._public(Boolean.valueOf(true)).assets(new LiveStreamAssets().iframe("<iframe src=\"https://embed.api.video/live/li400mYKSgQ6xs7taUeSaEKr\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/live/li400mYKSgQ6xs7taUeSaEKr")).hls(URI.create("https://live.api.video/li400mYKSgQ6xs7taUeSaEKr.m3u8")).thumbnail(URI.create("https://live.api.video/li400mYKSgQ6xs7taUeSaEKr/thumbnail.jpg"))).restreams(Arrays.asList(new RestreamsResponseObject().name("YouTube").serverUrl("rtmp://youtube.broadcast.example.com").streamKey("cc1b4df0-d1c5-4064-a8f9-9f0368385188"), new RestreamsResponseObject().name("Twitch").serverUrl("rtmp://twitch.broadcast.example.com").streamKey("cc1b4df0-d1c5-4064-a8f9-9f0368385188"))), new LiveStream().updatedAt(OffsetDateTime.parse("2020-07-29T10:45:35Z")).createdAt(OffsetDateTime.parse("2020-07-29T10:45:35Z")).liveStreamId("li4pqNqGUkhKfWcBGpZVLRY5").streamKey("cc1b4df0-d1c5-4064-a8f9-9f0368385135").name("Live From New York").broadcasting(Boolean.valueOf(false))._public(Boolean.valueOf(true)).assets(new LiveStreamAssets().iframe("<iframe src=\"https://embed.api.video/live/li4pqNqGUkhKfWcBGpZVLRY5\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/live/li4pqNqGUkhKfWcBGpZVLRY5")).hls(URI.create("https://live.api.video/li4pqNqGUkhKfWcBGpZVLRY5.m3u8")).thumbnail(URI.create("https://live.api.video/li4pqNqGUkhKfWcBGpZVLRY5/thumbnail.jpg"))).restreams(Arrays.asList(new RestreamsResponseObject().name("YouTube").serverUrl("rtmp://youtube.broadcast.example.com").streamKey("cc1b4df0-d1c5-4064-a8f9-9f0368385135"), new RestreamsResponseObject().name("Twitch").serverUrl("rtmp://twitch.broadcast.example.com").streamKey("cc1b4df0-d1c5-4064-a8f9-9f0368385135")))});
        }
    }

    @Nested
    @DisplayName(value="deleteThumbnail")
    class deleteThumbnail {
        private static final String PAYLOADS_PATH = "/payloads/livestreams/deleteThumbnail/";

        deleteThumbnail() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            LiveStreamsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.deleteThumbnail(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'liveStreamId' when calling deleteThumbnail");
            Assertions.assertThatNoException().isThrownBy(() -> LiveStreamsApiTest.this.api.deleteThumbnail("li400mYKSgQ6xs7taUeSaEKr"));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(200, "");
            LiveStream res = LiveStreamsApiTest.this.api.deleteThumbnail("li400mYKSgQ6xs7taUeSaEKr");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(404, LiveStreamsApiTest.this.readResourceFile("/payloads/livestreams/deleteThumbnail/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.deleteThumbnail("li400mYKSgQ6xs7taUeSaEKr")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="delete")
    class delete {
        private static final String PAYLOADS_PATH = "/payloads/livestreams/delete/";

        delete() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            LiveStreamsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LiveStreamsApiTest.this.api.delete(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'liveStreamId' when calling delete");
            Assertions.assertThatNoException().isThrownBy(() -> LiveStreamsApiTest.this.api.delete("li400mYKSgQ6xs7taUeSaEKr"));
        }

        @Test
        @DisplayName(value="204 response")
        public void responseWithStatus204Test() throws ApiException {
            LiveStreamsApiTest.this.answerOnAnyRequest(204, "");
            LiveStreamsApiTest.this.api.delete("li400mYKSgQ6xs7taUeSaEKr");
        }
    }
}

