/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.time.OffsetDateTime;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.WebhooksApi;
import video.api.client.api.models.Page;
import video.api.client.api.models.Webhook;
import video.api.client.api.models.WebhooksCreationPayload;

@DisplayName(value="WebhooksApi")
public class WebhooksApiTest
extends AbstractApiTest {
    private final WebhooksApi api;

    public WebhooksApiTest() {
        this.api = this.apiClientMock.webhooks();
    }

    @Nested
    @DisplayName(value="create")
    class create {
        private static final String PAYLOADS_PATH = "/payloads/webhooks/create/";

        create() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            WebhooksApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WebhooksApiTest.this.api.create(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'webhooksCreationPayload' when calling create");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WebhooksApiTest.this.api.create(new WebhooksCreationPayload())).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'webhooksCreationPayload.url' when calling create");
            Assertions.assertThatNoException().isThrownBy(() -> WebhooksApiTest.this.api.create(new WebhooksCreationPayload().url("url")));
        }

        @Test
        @DisplayName(value="201 response")
        public void responseWithStatus201Test() throws ApiException {
            WebhooksApiTest.this.answerOnAnyRequest(201, WebhooksApiTest.this.readResourceFile("/payloads/webhooks/create/responses/201.json"));
            WebhooksApiTest.this.api.create(new WebhooksCreationPayload().url("url"));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            WebhooksApiTest.this.answerOnAnyRequest(400, WebhooksApiTest.this.readResourceFile("/payloads/webhooks/create/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WebhooksApiTest.this.api.create(new WebhooksCreationPayload().url("url"))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).satisfies(e -> {
                ApiException apiException = (ApiException)e;
                Assertions.assertThat((List)apiException.getProblems()).containsExactlyInAnyOrder((Object[])new ApiException.ApiProblem[]{new ApiException.ApiProblem("https://docs.api.video/reference/attribute-required", "This attribute is required.", "events"), new ApiException.ApiProblem("https://docs.api.video/reference/attribute-required", "This attribute is required.", "url"), new ApiException.ApiProblem("https://docs.api.video/reference/invalid-attribute", "This attribute must be an array.", "events")});
            })).hasMessage("This attribute is required.");
        }
    }

    @Nested
    @DisplayName(value="list")
    class list {
        private static final String PAYLOADS_PATH = "/payloads/webhooks/list/";

        list() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            WebhooksApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> WebhooksApiTest.this.api.list().execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            WebhooksApiTest.this.answerOnAnyRequest(200, WebhooksApiTest.this.readResourceFile("/payloads/webhooks/list/responses/200.json"));
            Page page = WebhooksApiTest.this.api.list().execute();
            Assertions.assertThat((Integer)page.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)page.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)page.getPagesTotal()).isEqualTo(1);
            Assertions.assertThat((Integer)page.getCurrentPageItems()).isEqualTo(2);
            Assertions.assertThat((List)page.getItems()).hasSize(2);
            Assertions.assertThat((List)page.getItems()).containsExactlyInAnyOrder((Object[])new Webhook[]{new Webhook().webhookId("webhook_XXXXXXXXXXXXXXX").createdAt(OffsetDateTime.parse("2021-01-08T14:12:18.000+00:00")).addEventsItem("video.encoding.quality.completed").url("http://clientnotificationserver.com/notif?myquery=query").signatureSecret("sig_sec_Abcd12348RLP7VPLi7nYVh"), new Webhook().webhookId("webhook_XXXXXXXXXYYYYYY").createdAt(OffsetDateTime.parse("2021-01-12T12:12:12.000+00:00")).addEventsItem("video.encoding.quality.completed").url("http://clientnotificationserver.com/notif?myquery=query2").signatureSecret("sig_sec_Abcd12358RLP7VPLi7nYVy")});
        }
    }

    @Nested
    @DisplayName(value="get")
    class get {
        private static final String PAYLOADS_PATH = "/payloads/webhooks/get/";

        get() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            WebhooksApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WebhooksApiTest.this.api.get(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'webhookId' when calling get");
            Assertions.assertThatNoException().isThrownBy(() -> WebhooksApiTest.this.api.get("webhookId_example"));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            WebhooksApiTest.this.answerOnAnyRequest(200, WebhooksApiTest.this.readResourceFile("/payloads/webhooks/get/responses/200.json"));
            Webhook res = WebhooksApiTest.this.api.get("webhookId_example");
            Assertions.assertThat((String)res.getWebhookId()).isEqualTo("webhook_XXXXXXXXXXXXXXX");
            Assertions.assertThat((OffsetDateTime)res.getCreatedAt()).isEqualTo("2021-01-08T14:12:18.000+00:00");
            Assertions.assertThat((List)res.getEvents()).containsExactlyInAnyOrder((Object[])new String[]{"video.encoding.quality.completed"});
            Assertions.assertThat((String)res.getUrl()).isEqualTo("http://clientnotificationserver.com/notif?myquery=query");
        }
    }

    @Nested
    @DisplayName(value="delete")
    class delete {
        private static final String PAYLOADS_PATH = "/payloads/webhooks/delete/";

        delete() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            WebhooksApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WebhooksApiTest.this.api.delete(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'webhookId' when calling delete");
            Assertions.assertThatNoException().isThrownBy(() -> WebhooksApiTest.this.api.delete("webhookId_example"));
        }

        @Test
        @DisplayName(value="204 response")
        public void responseWithStatus204Test() throws ApiException {
            WebhooksApiTest.this.answerOnAnyRequest(204, "");
            Assertions.assertThatNoException().isThrownBy(() -> WebhooksApiTest.this.api.delete("webhookId_example"));
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            WebhooksApiTest.this.answerOnAnyRequest(404, WebhooksApiTest.this.readResourceFile("/payloads/webhooks/delete/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WebhooksApiTest.this.api.delete("webhookId_example")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }
}

