/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.io.File;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.CaptionsApi;
import video.api.client.api.models.Caption;
import video.api.client.api.models.CaptionsUpdatePayload;
import video.api.client.api.models.Page;

@DisplayName(value="CaptionsApi")
public class CaptionsApiTest
extends AbstractApiTest {
    private final CaptionsApi api;

    public CaptionsApiTest() {
        this.api = this.apiClientMock.captions();
    }

    @Nested
    @DisplayName(value="upload")
    class upload {
        private static final String PAYLOADS_PATH = "/payloads/captions/upload/";

        upload() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            CaptionsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.upload(null, "en", new File(""))).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling upload");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.upload("12", null, new File(""))).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'language' when calling upload");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.upload("12", "en", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'file' when calling upload");
            Assertions.assertThatNoException().isThrownBy(() -> CaptionsApiTest.this.api.upload("vi4k0jvEUuaTdRAEjQ4Prklg", "en", new File("")));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(200, CaptionsApiTest.this.readResourceFile("/payloads/captions/upload/responses/200.json"));
            Caption res = CaptionsApiTest.this.api.upload("vi4k0jvEUuaTdRAEjQ4Prklg", "en", new File(""));
            Assertions.assertThat((String)res.getUri()).isEqualTo("/videos/vi3N6cDinStg3oBbN79GklWS/captions/en");
            Assertions.assertThat((String)res.getSrc()).isEqualTo("https://cdn.api.video/vod/vi3N6cDinStg3oBbN79GklWS/captions/en.vtt");
            Assertions.assertThat((String)res.getSrclang()).isEqualTo("en");
            Assertions.assertThat((String)res.getLanguageName()).isEqualTo("English");
            Assertions.assertThat((Boolean)res.getDefault()).isEqualTo(false);
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(400, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.upload("vi4k0jvEUuaTdRAEjQ4Prklg", "en", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.upload("vi4k0jvEUuaTdRAEjQ4Prklg", "en", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="update")
    class update {
        private static final String PAYLOADS_PATH = "/payloads/captions/update/";

        update() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            CaptionsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.update(null, "en", new CaptionsUpdatePayload())).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling update");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.update("12", null, new CaptionsUpdatePayload())).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'language' when calling update");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.update("12", "en", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'captionsUpdatePayload' when calling update");
            Assertions.assertThatNoException().isThrownBy(() -> CaptionsApiTest.this.api.update("vi4k0jvEUuaTdRAEjQ4Prklg", "en", new CaptionsUpdatePayload()));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(200, CaptionsApiTest.this.readResourceFile("/payloads/captions/update/responses/200.json"));
            Caption res = CaptionsApiTest.this.api.update("vi4k0jvEUuaTdRAEjQ4Prklg", "en", new CaptionsUpdatePayload());
            Assertions.assertThat((String)res.getUri()).isEqualTo("/videos/vi3N6cDinStg3oBbN79GklWS/captions/en");
            Assertions.assertThat((String)res.getSrc()).isEqualTo("https://cdn.api.video/vod/vi3N6cDinStg3oBbN79GklWS/captions/en.vtt");
            Assertions.assertThat((String)res.getSrclang()).isEqualTo("en");
            Assertions.assertThat((String)res.getLanguageName()).isEqualTo("English");
            Assertions.assertThat((Boolean)res.getDefault()).isEqualTo(true);
        }

        @Test
        @DisplayName(value="400-0 response")
        public void responseWithStatus400Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(400, CaptionsApiTest.this.readResourceFile("/payloads/captions/update/responses/400-0.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.update("vi4k0jvEUuaTdRAEjQ4Prklg", "en_", new CaptionsUpdatePayload())).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("An attribute is invalid.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(404, CaptionsApiTest.this.readResourceFile("/payloads/captions/update/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.update("vi4k0jvEUuaTdRAEjQ4Prklg", "en", new CaptionsUpdatePayload())).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("sunt do fugiat tempor");
        }
    }

    @Nested
    @DisplayName(value="get")
    class get {
        private static final String PAYLOADS_PATH = "/payloads/captions/get/";

        get() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            CaptionsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.get(null, "en")).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling get");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.get("12", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'language' when calling get");
            Assertions.assertThatNoException().isThrownBy(() -> CaptionsApiTest.this.api.get("vi4k0jvEUuaTdRAEjQ4Prklg", "en"));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(200, CaptionsApiTest.this.readResourceFile("/payloads/captions/get/responses/200.json"));
            Caption res = CaptionsApiTest.this.api.get("vi4k0jvEUuaTdRAEjQ4Prklg", "en");
            Assertions.assertThat((String)res.getUri()).isEqualTo("/videos/vi3N6cDinStg3oBbN79GklWS/captions/en");
            Assertions.assertThat((String)res.getSrc()).isEqualTo("https://cdn.api.video/vod/vi3N6cDinStg3oBbN79GklWS/captions/en.vtt");
            Assertions.assertThat((String)res.getSrclang()).isEqualTo("en");
            Assertions.assertThat((String)res.getLanguageName()).isEqualTo("English");
            Assertions.assertThat((Boolean)res.getDefault()).isEqualTo(false);
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.get("vi4k0jvEUuaTdRAEjQ4Prklg", "en")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="list")
    class list {
        private static final String PAYLOADS_PATH = "/payloads/captions/list/";

        list() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            CaptionsApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> CaptionsApiTest.this.api.list("vi4k0jvEUuaTdRAEjQ4Prklg").execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(200, CaptionsApiTest.this.readResourceFile("/payloads/captions/list/responses/200.json"));
            Page res = CaptionsApiTest.this.api.list("vi4k0jvEUuaTdRAEjQ4Prklg").execute();
            Assertions.assertThat((Integer)res.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)res.getPagesTotal()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getCurrentPageItems()).isEqualTo(2);
            Assertions.assertThat((List)res.getItems()).hasSize(2);
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new Caption[]{new Caption().src("https://cdn.api.video/vod/vi3N6cDinStg3oBbN79GklWS/captions/en.vtt").uri("/videos/vi3N6cDinStg3oBbN79GklWS/captions/en").srclang("en").languageName("English")._default(Boolean.valueOf(false)), new Caption().src("https://cdn.api.video/vod/vi3N6cDinStg3oBbN79GklWS/captions/fr.vtt").uri("/videos/vi3N6cDinStg3oBbN79GklWS/captions/fr").srclang("fr").languageName("Fran\u00e7aise")._default(Boolean.valueOf(false))});
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.list("vi4k0jvEUuaTdRAEjQ4Prklg").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="delete")
    class delete {
        delete() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            CaptionsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.delete(null, "en")).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling delete");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.delete("12", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'language' when calling delete");
            Assertions.assertThatNoException().isThrownBy(() -> CaptionsApiTest.this.api.delete("vi4k0jvEUuaTdRAEjQ4Prklgc", "en"));
        }

        @Test
        @DisplayName(value="204 response")
        public void responseWithStatus204Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(204, "");
            CaptionsApiTest.this.api.delete("vi4k0jvEUuaTdRAEjQ4Prklgc", "en");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            CaptionsApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CaptionsApiTest.this.api.delete("vi4k0jvEUuaTdRAEjQ4Prklgc", "en")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }
}

