/*
 * Decompiled with CFR 0.152.
 */
package video.api.integration;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiException;
import video.api.client.api.models.Metadata;
import video.api.client.api.models.Page;
import video.api.client.api.models.Video;
import video.api.client.api.models.VideoCreationPayload;
import video.api.client.api.models.VideoStatus;
import video.api.client.api.models.VideoThumbnailPickPayload;
import video.api.client.api.models.VideoUpdatePayload;
import video.api.integration.AbstractTest;

@DisplayName(value="Integration tests of api.videos() methods")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@EnabledIfEnvironmentVariable(named="INTEGRATION_TESTS_API_KEY", matches=".+")
public class VideosAsyncTest
extends AbstractTest {

    @Nested
    @DisplayName(value="video status")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class VideoStatusTest {
        private Video testVideo;

        VideoStatusTest() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosAsyncTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Android-SDK-tests] videoStatus"));
        }

        @Test
        public void getVideoStatus() throws ApiException, ExecutionException, InterruptedException, TimeoutException {
            final CompletableFuture futureVideoStatus = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().getStatusAsync(this.testVideo.getVideoId(), (ApiCallback)new ApiCallback<VideoStatus>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    futureVideoStatus.completeExceptionally((Throwable)e);
                }

                public void onSuccess(VideoStatus result, int statusCode, Map<String, List<String>> responseHeaders) {
                    futureVideoStatus.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            VideoStatus videoStatus = (VideoStatus)futureVideoStatus.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)videoStatus.getIngest()).isNull();
            Assertions.assertThat((Object)videoStatus.getEncoding()).isNotNull();
            Assertions.assertThat((Boolean)videoStatus.getEncoding().getPlayable()).isFalse();
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosAsyncTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="thumbnail")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class Thumbnail {
        private Video testVideo;

        Thumbnail() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosAsyncTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Android-SDK-tests] thumbnail"));
        }

        @Test
        public void uploadThumbnail() throws ApiException, IOException, ExecutionException, InterruptedException, TimeoutException {
            File jpgFile = new File(this.getClass().getResource("/assets/cat.jpg").getFile());
            final CompletableFuture futureVideo = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().uploadThumbnailAsync(this.testVideo.getVideoId(), jpgFile, (ApiCallback)new ApiCallback<Video>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    futureVideo.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Video result, int statusCode, Map<String, List<String>> responseHeaders) {
                    futureVideo.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Video video = (Video)futureVideo.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)video.getAssets()).isNotNull();
            Assertions.assertThat((URI)video.getAssets().getThumbnail()).isNotNull();
        }

        @Test
        public void pickThumbnail() throws ApiException, ExecutionException, InterruptedException, TimeoutException {
            final CompletableFuture futureVideo = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().pickThumbnailAsync(this.testVideo.getVideoId(), new VideoThumbnailPickPayload().timecode("00:00:02"), (ApiCallback)new ApiCallback<Video>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    futureVideo.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Video result, int statusCode, Map<String, List<String>> responseHeaders) {
                    futureVideo.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Video video = (Video)futureVideo.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)video.getAssets()).isNotNull();
            Assertions.assertThat((URI)video.getAssets().getThumbnail()).isNotNull();
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosAsyncTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="list with tags")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class ListWithTags {
        private Video testVideo;

        ListWithTags() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosAsyncTest.this.apiClient.videos().create(new VideoCreationPayload().tags(Arrays.asList("tag1", "tag2")).title("[Android-SDK-tests] list tags"));
        }

        @Test
        public void listTagNotFound() throws ApiException, ExecutionException, InterruptedException, TimeoutException {
            final CompletableFuture futurePage = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().list().tags(Collections.singletonList("valueNotFound")).executeAsync((ApiCallback)new ApiCallback<Page<Video>>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    futurePage.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Page<Video> result, int statusCode, Map<String, List<String>> responseHeaders) {
                    futurePage.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Page page = (Page)futurePage.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Integer)page.getItemsTotal()).isEqualTo(0);
        }

        @Test
        public void listTagFound() throws ApiException, ExecutionException, InterruptedException, TimeoutException {
            final CompletableFuture futurePage = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().list().tags(Arrays.asList("tag1", "tag2")).executeAsync((ApiCallback)new ApiCallback<Page<Video>>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    futurePage.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Page<Video> result, int statusCode, Map<String, List<String>> responseHeaders) {
                    futurePage.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Page page = (Page)futurePage.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Integer)page.getItemsTotal()).isGreaterThan(0);
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosAsyncTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="list with metadata")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class ListWithMetadata {
        private Video testVideo;

        ListWithMetadata() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosAsyncTest.this.apiClient.videos().create(new VideoCreationPayload().metadata(Collections.singletonList(new Metadata("key1", "value1"))).title("[Android-SDK-tests] list metadatas"));
        }

        @Test
        public void listMetadataNotFound() throws ApiException, ExecutionException, InterruptedException, TimeoutException {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("key1", "valueNotFound");
            final CompletableFuture futurePage = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().list().metadata(metadata).executeAsync((ApiCallback)new ApiCallback<Page<Video>>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    futurePage.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Page<Video> result, int statusCode, Map<String, List<String>> responseHeaders) {
                    futurePage.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Page page = (Page)futurePage.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Integer)page.getItemsTotal()).isEqualTo(0);
        }

        @Test
        public void listMetadataFound() throws ApiException, ExecutionException, InterruptedException, TimeoutException {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("key1", "value1");
            final CompletableFuture futurePage = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().list().metadata(metadata).executeAsync((ApiCallback)new ApiCallback<Page<Video>>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    futurePage.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Page<Video> result, int statusCode, Map<String, List<String>> responseHeaders) {
                    futurePage.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Page page = (Page)futurePage.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Integer)page.getItemsTotal()).isGreaterThan(0);
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosAsyncTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="get")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class Get {
        private Video testVideo;

        Get() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosAsyncTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Android-SDK-tests] get"));
        }

        @Test
        public void get() throws ApiException, ExecutionException, InterruptedException, TimeoutException {
            final CompletableFuture videoFuture = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().getAsync(this.testVideo.getVideoId(), (ApiCallback)new ApiCallback<Video>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    videoFuture.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Video result, int statusCode, Map<String, List<String>> responseHeaders) {
                    videoFuture.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Video video = (Video)videoFuture.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)video.getVideoId()).isEqualTo(this.testVideo.getVideoId());
            Assertions.assertThat((String)video.getTitle()).isEqualTo(this.testVideo.getTitle());
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosAsyncTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }

    @Nested
    @DisplayName(value="update")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class Update {
        private Video testVideo;

        Update() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = VideosAsyncTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Android-SDK-tests] video updates"));
        }

        @Test
        public void addMetadata() throws ApiException, ExecutionException, InterruptedException, TimeoutException {
            final CompletableFuture updatedFuture = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().updateAsync(this.testVideo.getVideoId(), new VideoUpdatePayload().addMetadataItem(new Metadata("firstKey", "firstValue")).addMetadataItem(new Metadata("secondKey", "secondValue")), (ApiCallback)new ApiCallback<Video>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    updatedFuture.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Video result, int statusCode, Map<String, List<String>> responseHeaders) {
                    updatedFuture.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Video updated = (Video)updatedFuture.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((List)updated.getMetadata()).containsExactlyInAnyOrder((Object[])new Metadata[]{new Metadata("firstKey", "firstValue"), new Metadata("secondKey", "secondValue")});
            final CompletableFuture updatedFuture2 = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().updateAsync(this.testVideo.getVideoId(), new VideoUpdatePayload().metadata(updated.addMetadataItem(new Metadata("thirdKey", "thirdValue")).getMetadata()), (ApiCallback)new ApiCallback<Video>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    updatedFuture2.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Video result, int statusCode, Map<String, List<String>> responseHeaders) {
                    updatedFuture2.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Video updated2 = (Video)updatedFuture2.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((List)updated2.getMetadata()).containsExactlyInAnyOrder((Object[])new Metadata[]{new Metadata("firstKey", "firstValue"), new Metadata("secondKey", "secondValue"), new Metadata("thirdKey", "thirdValue")});
            final CompletableFuture updatedFuture3 = new CompletableFuture();
            VideosAsyncTest.this.apiClient.videos().updateAsync(this.testVideo.getVideoId(), new VideoUpdatePayload().metadata(Collections.emptyList()), (ApiCallback)new ApiCallback<Video>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    updatedFuture3.completeExceptionally((Throwable)e);
                }

                public void onSuccess(Video result, int statusCode, Map<String, List<String>> responseHeaders) {
                    updatedFuture3.complete(result);
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            Video updated3 = (Video)updatedFuture3.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((List)updated3.getMetadata()).isEmpty();
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            VideosAsyncTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }
}

