/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.features.observationtable;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import de.learnlib.algorithms.features.observationtable.ObservationTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.automatalib.words.Word;

public abstract class AbstractObservationTable<I, O>
implements ObservationTable<I, O> {
    private final Function<ObservationTable.Row<I, O>, Word<I>> getLabel = new Function<ObservationTable.Row<I, O>, Word<I>>(){

        public Word<I> apply(ObservationTable.Row<I, O> row) {
            return row.getLabel();
        }
    };

    @Override
    public Collection<? extends Word<I>> getShortPrefixes() {
        Collection spRows = this.getShortPrefixRows();
        return Collections2.transform(spRows, this.getLabel);
    }

    @Override
    public Collection<? extends Word<I>> getLongPrefixes() {
        Collection lpRows = this.getLongPrefixRows();
        return Collections2.transform(lpRows, this.getLabel);
    }

    @Override
    public Collection<? extends Word<I>> getAllPrefixes() {
        Collection<Word<I>> shortPrefixes = this.getShortPrefixes();
        Collection<Word<I>> longPrefixes = this.getLongPrefixes();
        ArrayList<Word<I>> result = new ArrayList<Word<I>>(shortPrefixes.size() + longPrefixes.size());
        result.addAll(shortPrefixes);
        result.addAll(longPrefixes);
        return result;
    }

    public List<? extends ObservationTable.Row<I, O>> getAllRows() {
        Collection spRows = this.getShortPrefixRows();
        Collection lpRows = this.getLongPrefixRows();
        ArrayList result = new ArrayList(spRows.size() + lpRows.size());
        result.addAll(spRows);
        result.addAll(lpRows);
        return result;
    }

    @Override
    public ObservationTable.Row<I, O> getRow(Word<I> prefix) {
        for (ObservationTable.Row row : this.getAllRows()) {
            if (!prefix.equals(row.getLabel())) continue;
            return row;
        }
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.findUnclosedRow() == null;
    }

    @Override
    public ObservationTable.Row<I, O> findUnclosedRow() {
        HashSet spRowContents = new HashSet();
        for (ObservationTable.Row spRow : this.getShortPrefixRows()) {
            spRowContents.add(spRow.getContents());
        }
        for (ObservationTable.Row lpRow : this.getLongPrefixRows()) {
            if (spRowContents.contains(lpRow.getContents())) continue;
            return lpRow;
        }
        return null;
    }

    @Override
    public ObservationTable.Inconsistency<I, O> findInconsistency(Collection<? extends I> inputs) {
        HashMap spRowsByContent = new HashMap();
        for (ObservationTable.Row spRow : this.getShortPrefixRows()) {
            List content = spRow.getContents();
            ObservationTable.Row canonicalRow = (ObservationTable.Row)spRowsByContent.get(content);
            if (canonicalRow != null) {
                for (I inputSym : inputs) {
                    ObservationTable.Row canRowSucc;
                    ObservationTable.Row spRowSucc = this.getSuccessorRow(spRow, inputSym);
                    if (spRowSucc == (canRowSucc = this.getSuccessorRow(canonicalRow, inputSym)) || spRowSucc.getContents().equals(canRowSucc.getContents())) continue;
                    return new DefaultInconsistency(spRow, canonicalRow, inputSym);
                }
                continue;
            }
            spRowsByContent.put(content, spRow);
        }
        return null;
    }

    @Override
    public Word<I> getSuffix(int index) {
        return this.getSuffixes().get(index);
    }

    @Override
    public int findDistinguishingSuffixIndex(ObservationTable.Inconsistency<I, O> inconsistency) {
        ObservationTable.Row<I, O> row1 = inconsistency.getFirstRow();
        ObservationTable.Row<I, O> row2 = inconsistency.getSecondRow();
        I sym = inconsistency.getSymbol();
        ObservationTable.Row<I, O> succRow1 = this.getSuccessorRow(row1, sym);
        ObservationTable.Row<I, O> succRow2 = this.getSuccessorRow(row2, sym);
        return this.findDistinguishingSuffixIndex(succRow1, succRow2);
    }

    @Override
    public Word<I> findDistinguishingSuffix(ObservationTable.Inconsistency<I, O> inconsistency) {
        int suffixIndex = this.findDistinguishingSuffixIndex(inconsistency);
        if (suffixIndex != -1) {
            return null;
        }
        return this.getSuffix(suffixIndex);
    }

    @Override
    public Word<I> findDistinguishingSuffix(ObservationTable.Row<I, O> row1, ObservationTable.Row<I, O> row2) {
        int suffixIndex = this.findDistinguishingSuffixIndex(row1, row2);
        if (suffixIndex != -1) {
            return null;
        }
        return this.getSuffix(suffixIndex);
    }

    @Override
    public int findDistinguishingSuffixIndex(ObservationTable.Row<I, O> row1, ObservationTable.Row<I, O> row2) {
        Iterator<O> values1It = row1.getContents().iterator();
        Iterator<O> values2It = row2.getContents().iterator();
        int i = 0;
        while (values1It.hasNext() && values2It.hasNext()) {
            O value2;
            O value1 = values1It.next();
            if (!Objects.equal(value1, value2 = values2It.next())) {
                return i;
            }
            ++i;
        }
        if (values1It.hasNext() || values2It.hasNext()) {
            throw new IllegalStateException("Rows [" + row1.getLabel() + "] and/or [" + row2.getLabel() + "] have invalid length");
        }
        return -1;
    }

    @Override
    public boolean isConsistent(Collection<? extends I> inputs) {
        return this.findInconsistency(inputs) == null;
    }

    public static class DefaultInconsistency<I, O>
    implements ObservationTable.Inconsistency<I, O> {
        private final ObservationTable.Row<I, O> firstRow;
        private final ObservationTable.Row<I, O> secondRow;
        private final I symbol;

        public DefaultInconsistency(ObservationTable.Row<I, O> firstRow, ObservationTable.Row<I, O> secondRow, I symbol) {
            this.firstRow = firstRow;
            this.secondRow = secondRow;
            this.symbol = symbol;
        }

        @Override
        public ObservationTable.Row<I, O> getFirstRow() {
            return this.firstRow;
        }

        @Override
        public ObservationTable.Row<I, O> getSecondRow() {
            return this.secondRow;
        }

        @Override
        public I getSymbol() {
            return this.symbol;
        }
    }

    public static abstract class AbstractRow<I, O>
    implements ObservationTable.Row<I, O> {
        @Override
        public Iterator<O> iterator() {
            return Collections.unmodifiableCollection(this.getContents()).iterator();
        }

        @Override
        public int size() {
            return this.getContents().size();
        }

        @Override
        public O getCellContent(int index) {
            return this.getContents().get(index);
        }
    }
}

