/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.features.observationtable;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import de.learnlib.algorithms.features.observationtable.ObservationTable;
import de.learnlib.algorithms.features.observationtable.reader.ObservationTableReader;
import de.learnlib.algorithms.features.observationtable.writer.ObservationTableHTMLWriter;
import de.learnlib.algorithms.features.observationtable.writer.ObservationTableWriter;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public abstract class OTUtils {
    private static final String HTML_FILE_HEADER = "<html><head>\n<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n<style type=\"text/css\">\ntable.learnlib-observationtable { border-width: 1px; border: solid; }\ntable.learnlib-observationtable th.suffixes-header { text-align: center; }\ntable.learnlib-observationtable th.prefix { vertical-align: top; }\ntable.learnlib-observationtable .suffix-column { text-align: left; }\ntable.learnlib-observationtable tr { border-width: 1px; border: solid; }\ntable.learnlib-observationtable tr.long-prefix { background-color: #dfdfdf; }\n</style></head>\n<body>\n";
    private static final String HTML_FILE_FOOTER = "</body></html>\n";

    public static <I, D> String toString(ObservationTable<? extends I, ? extends D> table, ObservationTableWriter<I, D> writer) {
        StringBuilder sb = new StringBuilder();
        writer.write(table, sb);
        return sb.toString();
    }

    public static <I, D> ObservationTable<I, D> fromString(String source, Alphabet<I> alphabet, ObservationTableReader<I, D> reader) {
        return reader.read(source, alphabet);
    }

    public static <I, D> void writeHTMLToFile(ObservationTable<I, D> table, File file, Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write(HTML_FILE_HEADER);
            ObservationTableHTMLWriter<I, D> otWriter = new ObservationTableHTMLWriter<I, D>(wordToString, outputToString);
            otWriter.write(table, bw);
            bw.write(HTML_FILE_FOOTER);
        }
    }

    public static <I, D> void writeHTMLToFile(ObservationTable<I, D> table, File file) throws IOException {
        OTUtils.writeHTMLToFile(table, file, Functions.toStringFunction(), Functions.toStringFunction());
    }

    public static <I, D> void displayHTMLInBrowser(ObservationTable<I, D> table, Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString) throws IOException, HeadlessException, UnsupportedOperationException {
        File tempFile = File.createTempFile("learnlib-ot", ".html");
        OTUtils.writeHTMLToFile(table, tempFile, wordToString, outputToString);
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(tempFile.toURI());
    }

    public static <I, D> void displayHTMLInBrowser(ObservationTable<I, D> table) throws IOException, HeadlessException, UnsupportedOperationException {
        OTUtils.displayHTMLInBrowser(table, Functions.toStringFunction(), Functions.toStringFunction());
    }

    private OTUtils() {
        throw new AssertionError((Object)"Constructor should never be invoked");
    }
}

