/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.features.observationtable;

import de.learnlib.algorithms.features.observationtable.InvalidRowException;
import de.learnlib.algorithms.features.observationtable.NoSuchRowException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Signed;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public interface ObservationTable<I, D> {
    public static final int NO_DISTINGUISHING_SUFFIX = -1;

    @Nonnull
    public Collection<? extends Word<I>> getShortPrefixes();

    @Nonnull
    public Collection<? extends Word<I>> getLongPrefixes();

    @Nonnull
    public Collection<? extends Word<I>> getAllPrefixes();

    @Nonnull
    public List<? extends Word<I>> getSuffixes();

    @Nonnull
    public Word<I> getSuffix(@Nonnegative int var1) throws IndexOutOfBoundsException;

    @Nonnull
    public Collection<? extends Row<I, D>> getShortPrefixRows();

    @Nonnull
    public Collection<? extends Row<I, D>> getLongPrefixRows();

    @Nonnull
    public Collection<? extends Row<I, D>> getAllRows();

    @Nonnull
    public Row<I, D> getRow(Word<I> var1) throws NoSuchRowException;

    @Nullable
    public Row<I, D> getSuccessorRow(Row<I, D> var1, @Nullable I var2) throws InvalidRowException;

    public boolean isClosed();

    @Nullable
    public Row<I, D> findUnclosedRow();

    public boolean isConsistent(Collection<? extends I> var1);

    @Nullable
    public Inconsistency<I, D> findInconsistency(Collection<? extends I> var1);

    @Signed
    public int findDistinguishingSuffixIndex(Inconsistency<I, D> var1) throws NoSuchRowException, InvalidRowException;

    @Nullable
    public Word<I> findDistinguishingSuffix(Inconsistency<I, D> var1) throws NoSuchRowException, InvalidRowException;

    @Signed
    public int findDistinguishingSuffixIndex(Row<I, D> var1, Row<I, D> var2) throws InvalidRowException;

    @Nullable
    public Word<I> findDistinguishingSuffix(Row<I, D> var1, Row<I, D> var2) throws InvalidRowException;

    public static interface Inconsistency<I, D> {
        @Nonnull
        public Row<I, D> getFirstRow();

        @Nonnull
        public Row<I, D> getSecondRow();

        @Nullable
        public I getSymbol();
    }

    public static interface Row<I, D>
    extends Iterable<D> {
        @Nonnull
        public Word<I> getLabel();

        public boolean isShortPrefixRow();

        @Nonnull
        public List<? extends D> getContents();

        public int size();

        @Nullable
        public D getCellContent(@Nonnegative int var1) throws IndexOutOfBoundsException;
    }
}

