/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor;

import de.srsoftware.document.api.BytesContent;
import de.srsoftware.document.api.Content;
import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.RenderError;
import de.srsoftware.document.api.RenderResult;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class FileProcessor
implements Document {
    private static final System.Logger LOGGER = System.getLogger(FileProcessor.class.getSimpleName());

    protected abstract List<String> command(Map<String, Object> var1);

    private void delete(File tempDir) {
        File[] children;
        if (tempDir.isDirectory() && (children = tempDir.listFiles()) != null) {
            for (File child : children) {
                this.delete(child);
            }
        }
        boolean ignored = tempDir.delete();
    }

    public abstract List<Document> precursors();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderResult render(Map<String, Object> data) {
        Path tempDir = null;
        try {
            Content content;
            RenderError renderError;
            tempDir = Files.createTempDirectory(this.name().split("\\.")[0] + "-", new FileAttribute[0]);
            for (Document precursor : this.precursors()) {
                RenderResult doc = precursor.render(data);
                if (doc instanceof RenderError) {
                    RenderError err;
                    renderError = err = (RenderError)doc;
                    return renderError;
                }
                if (!(doc instanceof Content)) continue;
                content = (Content)doc;
                Path file = tempDir.resolve(precursor.name());
                LOGGER.log(System.Logger.Level.DEBUG, "writing {0}\u2026", file);
                Files.write(file, content.bytes(), new OpenOption[0]);
            }
            List<String> command = this.command(data);
            LOGGER.log(System.Logger.Level.DEBUG, "launching {0} @ {1}", String.join((CharSequence)" ", command), tempDir);
            Process process = new ProcessBuilder(command).directory(tempDir.toFile()).start();
            boolean gracefullyTerminated = process.waitFor(this.timeout().getSeconds(), TimeUnit.SECONDS);
            if (!gracefullyTerminated) {
                content = RenderError.of((String)"Rendering \"{0}\" failed! '{1}' timed out", (Object[])new Object[]{this.id(), String.join((CharSequence)" ", command)});
                return content;
            }
            Path target = tempDir.resolve(this.name());
            LOGGER.log(System.Logger.Level.DEBUG, "Fetching content of {0}\u2026", target);
            renderError = new BytesContent(Files.readAllBytes(target), this.mimeType());
            return renderError;
        }
        catch (Exception e) {
            RenderError renderError = RenderError.of((String)"Failed to render \"{0}\"", (Object[])new Object[]{this.id()}).add(e);
            return renderError;
        }
        finally {
            if (tempDir != null) {
                this.delete(tempDir.toFile());
            }
        }
    }

    public abstract String software();

    public Duration timeout() {
        return Duration.ofSeconds(10L);
    }

    public String toString() {
        return "%s (%s)".formatted(this.getClass().getSimpleName(), this.name());
    }
}

