/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor;

import de.srsoftware.document.api.Content;
import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.RenderError;
import de.srsoftware.document.api.RenderResult;
import de.srsoftware.document.api.StreamContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class PipeProcessor
implements Document {
    private static final System.Logger LOGGER = System.getLogger(PipeProcessor.class.getSimpleName());

    protected abstract List<String> command(Map<String, Object> var1);

    protected abstract Document precursor();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RenderResult render(Map<String, Object> data) {
        RenderResult precursor = this.precursor().render(data);
        if (precursor instanceof Content) {
            Content content = (Content)precursor;
            LOGGER.log(System.Logger.Level.DEBUG, "content of precursor ({1}): {0}", precursor.toString(), this.precursor().id());
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            try (InputStream stream = content.inputStream();){
                List<String> command = this.command(data);
                LOGGER.log(System.Logger.Level.DEBUG, "launching {0}", String.join((CharSequence)" ", command));
                Process process = new ProcessBuilder(command).start();
                InputStream stdOut = process.getInputStream();
                InputStream stdErr = process.getErrorStream();
                OutputStream stdIn = process.getOutputStream();
                stream.transferTo(stdIn);
                stdIn.close();
                boolean gracefullyTerminated = process.waitFor(this.timeout().getSeconds(), TimeUnit.SECONDS);
                if (!gracefullyTerminated) {
                    RenderError renderError = RenderError.of((String)"Rendering \"{0}\" failed! '{1}' timed out", (Object[])new Object[]{this.id(), String.join((CharSequence)" ", command)});
                    return renderError;
                }
                stdErr.transferTo(err);
                if (err.size() > 0) {
                    stdOut.close();
                    RenderError renderError = RenderError.of((String)"Failed to render {0}: {1}", (Object[])new Object[]{this.id(), err.toString(StandardCharsets.UTF_8)});
                    return renderError;
                }
                RenderResult renderResult = StreamContent.of((InputStream)stdOut, (String)this.mimeType());
                return renderResult;
            }
            catch (IOException | InterruptedException e) {
                return RenderError.of((String)"Failed to render {0}", (Object[])new Object[]{this.id()}).add(e);
            }
        }
        if (precursor instanceof RenderError) {
            return (RenderError)precursor;
        }
        return RenderError.of((String)"Failed to render {0}: unable to render precursor {1}", (Object[])new Object[]{this.id(), this.precursor().id()});
    }

    public Duration timeout() {
        return Duration.ofSeconds(10L);
    }
}

