/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor.figlet;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.DocumentFactory;
import de.srsoftware.document.api.DocumentRegistry;
import de.srsoftware.document.processor.figlet.FigletDoc;
import java.util.stream.Stream;

public class FigletFactory
implements DocumentFactory {
    private DocumentRegistry registry;

    private Document createGenerator(final Document txt) {
        return new FigletDoc(this){

            @Override
            protected Document source() {
                return txt;
            }

            @Override
            public Document precursor() {
                return txt;
            }
        };
    }

    public Stream<Document> documents() {
        return this.registry.documents().filter(document -> "text/plain".equals(document.mimeType())).filter(document -> !document.id().endsWith(".figlet.txt")).map(this::createGenerator);
    }

    public String description() {
        return "Creates figlet text files from text files";
    }

    public FigletFactory setRegistry(DocumentRegistry registry) {
        this.registry = registry;
        super.setRegistry(registry);
        return this;
    }
}

