/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor.latex;

import de.srsoftware.document.api.Content;
import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.DocumentFactory;
import de.srsoftware.document.api.DocumentRegistry;
import de.srsoftware.document.api.RenderResult;
import de.srsoftware.document.processor.latex.LatexDoc;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class LatexFactory
implements DocumentFactory {
    private static final Pattern PATTERN = Pattern.compile("\\\\input\\{([^}]+)\\}");
    private DocumentRegistry registry;

    private Document createGenerator(final Document tex) {
        return new LatexDoc(){

            @Override
            protected Document source() {
                return tex;
            }

            @Override
            public List<Document> precursors() {
                HashSet<Document> precursors = new HashSet<Document>();
                LatexFactory.this.findPrecursors(tex, precursors);
                return List.copyOf(precursors);
            }
        };
    }

    public String description() {
        return "This factory provides rendering of LaTeX documents to various formats.";
    }

    public Stream<Document> documents() {
        return this.registry.documents().filter(document -> "text/x-tex".equals(document.mimeType())).map(this::createGenerator);
    }

    public void findPrecursors(Document tex, Set<Document> precursors) {
        precursors.add(tex);
        RenderResult renderResult = tex.render(null);
        if (renderResult instanceof Content) {
            Content content = (Content)renderResult;
            String code = content.toString();
            Matcher m = PATTERN.matcher(code);
            List docs = this.registry.documents().toList();
            while (m.find()) {
                Object name = m.group(1);
                if (!((String)name).endsWith(".tex")) {
                    name = (String)name + ".tex";
                }
                String path = new File(tex.id()).getParent() + "/" + (String)name;
                Optional<Document> candidate = docs.stream().filter(doc -> doc.id().equals(path)).findAny();
                if (candidate.isPresent()) {
                    this.findPrecursors(candidate.get(), precursors);
                    continue;
                }
                for (Document doc2 : docs) {
                    if (!doc2.id().endsWith((String)name)) continue;
                    this.findPrecursors(doc2, precursors);
                }
            }
        }
    }

    public LatexFactory setRegistry(DocumentRegistry registry) {
        this.registry = registry;
        super.setRegistry(registry);
        return this;
    }
}

