/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.gmhttps.client;

import cn.gmssl.jce.provider.GMJCE;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;

public class ClientBuilder {
    static SSLContext createSSLContext(KeyStore keypair, String pwd) throws NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException, UnrecoverableKeyException, KeyStoreException {
        SSLContext sc = SSLContext.getInstance("GMSSLv1.1", "GMJSSE");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                for (X509Certificate x509Certificate : paramArrayOfX509Certificate) {
                    System.out.println(x509Certificate.getSubjectDN().getName());
                }
                System.out.println();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                for (X509Certificate x509Certificate : paramArrayOfX509Certificate) {
                    System.out.println(x509Certificate.getSubjectDN().getName());
                }
                System.out.println();
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        KeyManager[] kms = null;
        if (keypair != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keypair, pwd.toCharArray());
            kms = kmf.getKeyManagers();
        }
        sc.init(kms, new TrustManager[]{trustManager}, null);
        return sc;
    }

    static HttpClient initGMSSL() {
        return ClientBuilder.initGMSSL(null, null);
    }

    static HttpClient initGMSSL(InputStream cert, String pwd) {
        try {
            Security.insertProviderAt((Provider)new GMJCE(), 1);
            Security.insertProviderAt((Provider)Class.forName("cn.gmssl.jsse.provider.GMJSSE").newInstance(), 2);
            KeyStore keyStore = null;
            if (cert != null) {
                keyStore = KeyStore.getInstance("PKCS12", "GMJCE");
                keyStore.load(cert, pwd.toCharArray());
            }
            SSLContext sslContext = ClientBuilder.createSSLContext(keyStore, pwd);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"GMSSLv1.1"}, new String[]{"ECC_SM4_CBC_SM3"}, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).build();
            int timeout = 30;
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
            HttpClientBuilder b = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry)).setMaxConnPerRoute(20).setMaxConnTotal(400).setDefaultRequestConfig(config);
            return b.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

