/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.gmhttps.server;

import cc.kkon.gmhttps.model.ServerConfig;
import cc.kkon.gmhttps.server.AcceptRunner;
import cc.kkon.gmhttps.utils.Strings;
import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;

public class SSLServer
implements Closeable {
    private final Map<String, HttpServlet> servlets;
    private final AcceptRunner acceptRunner;

    public SSLServer(int port, InputStream cert, String certPassword, boolean twoWayAuth) {
        ServerConfig cfg = new ServerConfig(port, cert, certPassword, twoWayAuth, 20);
        this.servlets = new HashMap<String, HttpServlet>();
        this.acceptRunner = new AcceptRunner(cfg, this.servlets);
    }

    public void listen() {
        Thread thread = new Thread(this.acceptRunner);
        thread.start();
        System.out.println("SSLServer started.");
    }

    public synchronized void addServlet(String urlPattern, HttpServlet servlet) {
        this.check(urlPattern);
        this.servlets.put(urlPattern, servlet);
    }

    public void addServlet(HttpServlet servlet) {
        String[] value;
        Class<?> clazz = servlet.getClass();
        WebServlet anno = clazz.getAnnotation(WebServlet.class);
        for (String val : value = anno.value()) {
            this.addServlet(val, servlet);
        }
    }

    private void check(String urlPattern) {
        if (Strings.isBlank((CharSequence)urlPattern)) {
            throw new RuntimeException("UrlPattern is blank.");
        }
        if (this.servlets.containsKey(urlPattern)) {
            throw new RuntimeException("UrlPattern existed.");
        }
    }

    @Override
    public void close() {
        this.acceptRunner.close();
        System.out.println("SSLServer closed.");
    }
}

