/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.session.defaults;

import cn.bugstack.chatglm.model.ChatCompletionRequest;
import cn.bugstack.chatglm.model.ChatCompletionResponse;
import cn.bugstack.chatglm.model.EventType;
import cn.bugstack.chatglm.session.Configuration;
import cn.bugstack.chatglm.session.OpenAiSession;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpenAiSession
implements OpenAiSession {
    private static final Logger log = LoggerFactory.getLogger(DefaultOpenAiSession.class);
    private final Configuration configuration;
    private final EventSource.Factory factory;

    public DefaultOpenAiSession(Configuration configuration) {
        this.configuration = configuration;
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public EventSource completions(ChatCompletionRequest chatCompletionRequest, EventSourceListener eventSourceListener) throws JsonProcessingException {
        Request request = new Request.Builder().url(this.configuration.getApiHost().concat("api/paas/v3/model-api/{model}/sse-invoke").replace("{model}", chatCompletionRequest.getModel().getCode())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)chatCompletionRequest.toString())).build();
        return this.factory.newEventSource(request, eventSourceListener);
    }

    @Override
    public CompletableFuture<String> completions(ChatCompletionRequest chatCompletionRequest) throws InterruptedException {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        final StringBuffer dataBuffer = new StringBuffer();
        Request request = new Request.Builder().url(this.configuration.getApiHost().concat("api/paas/v3/model-api/{model}/sse-invoke").replace("{model}", chatCompletionRequest.getModel().getCode())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)chatCompletionRequest.toString())).build();
        this.factory.newEventSource(request, new EventSourceListener(){

            public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
                ChatCompletionResponse response = (ChatCompletionResponse)JSON.parseObject((String)data, ChatCompletionResponse.class);
                if (EventType.add.getCode().equals(type)) {
                    dataBuffer.append(response.getData());
                } else if (EventType.finish.getCode().equals(type)) {
                    future.complete(dataBuffer.toString());
                }
            }

            public void onClosed(EventSource eventSource) {
                future.completeExceptionally(new RuntimeException("Request closed before completion"));
            }

            public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                future.completeExceptionally(new RuntimeException("Request closed before completion"));
            }
        });
        return future;
    }
}

