/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.session.defaults;

import cn.bugstack.chatglm.IOpenAiApi;
import cn.bugstack.chatglm.interceptor.OpenAiHTTPInterceptor;
import cn.bugstack.chatglm.session.Configuration;
import cn.bugstack.chatglm.session.OpenAiSession;
import cn.bugstack.chatglm.session.OpenAiSessionFactory;
import cn.bugstack.chatglm.session.defaults.DefaultOpenAiSession;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DefaultOpenAiSessionFactory
implements OpenAiSessionFactory {
    private final Configuration configuration;

    public DefaultOpenAiSessionFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public OpenAiSession openSession() {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(this.configuration.getLevel());
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)httpLoggingInterceptor).addInterceptor((Interceptor)new OpenAiHTTPInterceptor(this.configuration)).connectTimeout(this.configuration.getConnectTimeout(), TimeUnit.SECONDS).writeTimeout(this.configuration.getWriteTimeout(), TimeUnit.SECONDS).readTimeout(this.configuration.getReadTimeout(), TimeUnit.SECONDS).build();
        this.configuration.setOkHttpClient(okHttpClient);
        IOpenAiApi openAiApi = (IOpenAiApi)new Retrofit.Builder().baseUrl(this.configuration.getApiHost()).client(okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(IOpenAiApi.class);
        this.configuration.setOpenAiApi(openAiApi);
        return new DefaultOpenAiSession(this.configuration);
    }
}

