/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.aliyun.valobj;

import cn.bugstack.openai.executor.model.aliyun.valobj.Message;
import cn.bugstack.openai.executor.model.aliyun.valobj.Model;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AliModelCompletionRequest {
    private static final Logger log = LoggerFactory.getLogger(AliModelCompletionRequest.class);
    private String model = Model.QWEN_MAX.getCode();
    private Input input;
    private Parameters parameters;

    public static AliModelCompletionRequestBuilder builder() {
        return new AliModelCompletionRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public Input getInput() {
        return this.input;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AliModelCompletionRequest)) {
            return false;
        }
        AliModelCompletionRequest other = (AliModelCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        Input this$input = this.getInput();
        Input other$input = other.getInput();
        if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
            return false;
        }
        Parameters this$parameters = this.getParameters();
        Parameters other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AliModelCompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        Input $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
        Parameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "AliModelCompletionRequest(model=" + this.getModel() + ", input=" + this.getInput() + ", parameters=" + this.getParameters() + ")";
    }

    public AliModelCompletionRequest() {
    }

    public AliModelCompletionRequest(String model, Input input, Parameters parameters) {
        this.model = model;
        this.input = input;
        this.parameters = parameters;
    }

    public static class AliModelCompletionRequestBuilder {
        private String model;
        private Input input;
        private Parameters parameters;

        AliModelCompletionRequestBuilder() {
        }

        public AliModelCompletionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public AliModelCompletionRequestBuilder input(Input input) {
            this.input = input;
            return this;
        }

        public AliModelCompletionRequestBuilder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public AliModelCompletionRequest build() {
            return new AliModelCompletionRequest(this.model, this.input, this.parameters);
        }

        public String toString() {
            return "AliModelCompletionRequest.AliModelCompletionRequestBuilder(model=" + this.model + ", input=" + this.input + ", parameters=" + this.parameters + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Input {
        private String prompt;
        private List<Message> messages;

        public static InputBuilder builder() {
            return new InputBuilder();
        }

        public String getPrompt() {
            return this.prompt;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        public void setMessages(List<Message> messages) {
            this.messages = messages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Input)) {
                return false;
            }
            Input other = (Input)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$prompt = this.getPrompt();
            String other$prompt = other.getPrompt();
            if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
                return false;
            }
            List<Message> this$messages = this.getMessages();
            List<Message> other$messages = other.getMessages();
            return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Input;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $prompt = this.getPrompt();
            result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
            List<Message> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            return result;
        }

        public String toString() {
            return "AliModelCompletionRequest.Input(prompt=" + this.getPrompt() + ", messages=" + this.getMessages() + ")";
        }

        public Input() {
        }

        public Input(String prompt, List<Message> messages) {
            this.prompt = prompt;
            this.messages = messages;
        }

        public static class InputBuilder {
            private String prompt;
            private List<Message> messages;

            InputBuilder() {
            }

            public InputBuilder prompt(String prompt) {
                this.prompt = prompt;
                return this;
            }

            public InputBuilder messages(List<Message> messages) {
                this.messages = messages;
                return this;
            }

            public Input build() {
                return new Input(this.prompt, this.messages);
            }

            public String toString() {
                return "AliModelCompletionRequest.Input.InputBuilder(prompt=" + this.prompt + ", messages=" + this.messages + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Parameters {
        private static final Logger log = LoggerFactory.getLogger(Parameters.class);
        @JsonProperty(value="result_format")
        private String resultFormat = "text";
        private Integer seed;
        @JsonProperty(value="max_tokens")
        private Integer maxTokens;
        @JsonProperty(value="top_p")
        private Float topP;
        @JsonProperty(value="top_k")
        private Float topK;
        @JsonProperty(value="repetition_penalty")
        private Float repetitionPenalty;
        private Float temperature;
        private List<String> stop;
        @JsonProperty(value="enable_search")
        private Boolean enableSearch;
        @JsonProperty(value="incremental_output")
        private Boolean incrementalOutput = true;

        public static ParametersBuilder builder() {
            return new ParametersBuilder();
        }

        public String getResultFormat() {
            return this.resultFormat;
        }

        public Integer getSeed() {
            return this.seed;
        }

        public Integer getMaxTokens() {
            return this.maxTokens;
        }

        public Float getTopP() {
            return this.topP;
        }

        public Float getTopK() {
            return this.topK;
        }

        public Float getRepetitionPenalty() {
            return this.repetitionPenalty;
        }

        public Float getTemperature() {
            return this.temperature;
        }

        public List<String> getStop() {
            return this.stop;
        }

        public Boolean getEnableSearch() {
            return this.enableSearch;
        }

        public Boolean getIncrementalOutput() {
            return this.incrementalOutput;
        }

        @JsonProperty(value="result_format")
        public void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        public void setSeed(Integer seed) {
            this.seed = seed;
        }

        @JsonProperty(value="max_tokens")
        public void setMaxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
        }

        @JsonProperty(value="top_p")
        public void setTopP(Float topP) {
            this.topP = topP;
        }

        @JsonProperty(value="top_k")
        public void setTopK(Float topK) {
            this.topK = topK;
        }

        @JsonProperty(value="repetition_penalty")
        public void setRepetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
        }

        public void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        public void setStop(List<String> stop) {
            this.stop = stop;
        }

        @JsonProperty(value="enable_search")
        public void setEnableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
        }

        @JsonProperty(value="incremental_output")
        public void setIncrementalOutput(Boolean incrementalOutput) {
            this.incrementalOutput = incrementalOutput;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameters)) {
                return false;
            }
            Parameters other = (Parameters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$seed = this.getSeed();
            Integer other$seed = other.getSeed();
            if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
                return false;
            }
            Integer this$maxTokens = this.getMaxTokens();
            Integer other$maxTokens = other.getMaxTokens();
            if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
                return false;
            }
            Float this$topP = this.getTopP();
            Float other$topP = other.getTopP();
            if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
                return false;
            }
            Float this$topK = this.getTopK();
            Float other$topK = other.getTopK();
            if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
                return false;
            }
            Float this$repetitionPenalty = this.getRepetitionPenalty();
            Float other$repetitionPenalty = other.getRepetitionPenalty();
            if (this$repetitionPenalty == null ? other$repetitionPenalty != null : !((Object)this$repetitionPenalty).equals(other$repetitionPenalty)) {
                return false;
            }
            Float this$temperature = this.getTemperature();
            Float other$temperature = other.getTemperature();
            if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
                return false;
            }
            Boolean this$enableSearch = this.getEnableSearch();
            Boolean other$enableSearch = other.getEnableSearch();
            if (this$enableSearch == null ? other$enableSearch != null : !((Object)this$enableSearch).equals(other$enableSearch)) {
                return false;
            }
            Boolean this$incrementalOutput = this.getIncrementalOutput();
            Boolean other$incrementalOutput = other.getIncrementalOutput();
            if (this$incrementalOutput == null ? other$incrementalOutput != null : !((Object)this$incrementalOutput).equals(other$incrementalOutput)) {
                return false;
            }
            String this$resultFormat = this.getResultFormat();
            String other$resultFormat = other.getResultFormat();
            if (this$resultFormat == null ? other$resultFormat != null : !this$resultFormat.equals(other$resultFormat)) {
                return false;
            }
            List<String> this$stop = this.getStop();
            List<String> other$stop = other.getStop();
            return !(this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameters;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $seed = this.getSeed();
            result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
            Integer $maxTokens = this.getMaxTokens();
            result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
            Float $topP = this.getTopP();
            result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
            Float $topK = this.getTopK();
            result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
            Float $repetitionPenalty = this.getRepetitionPenalty();
            result = result * 59 + ($repetitionPenalty == null ? 43 : ((Object)$repetitionPenalty).hashCode());
            Float $temperature = this.getTemperature();
            result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
            Boolean $enableSearch = this.getEnableSearch();
            result = result * 59 + ($enableSearch == null ? 43 : ((Object)$enableSearch).hashCode());
            Boolean $incrementalOutput = this.getIncrementalOutput();
            result = result * 59 + ($incrementalOutput == null ? 43 : ((Object)$incrementalOutput).hashCode());
            String $resultFormat = this.getResultFormat();
            result = result * 59 + ($resultFormat == null ? 43 : $resultFormat.hashCode());
            List<String> $stop = this.getStop();
            result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
            return result;
        }

        public String toString() {
            return "AliModelCompletionRequest.Parameters(resultFormat=" + this.getResultFormat() + ", seed=" + this.getSeed() + ", maxTokens=" + this.getMaxTokens() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", repetitionPenalty=" + this.getRepetitionPenalty() + ", temperature=" + this.getTemperature() + ", stop=" + this.getStop() + ", enableSearch=" + this.getEnableSearch() + ", incrementalOutput=" + this.getIncrementalOutput() + ")";
        }

        public Parameters(String resultFormat, Integer seed, Integer maxTokens, Float topP, Float topK, Float repetitionPenalty, Float temperature, List<String> stop, Boolean enableSearch, Boolean incrementalOutput) {
            this.resultFormat = resultFormat;
            this.seed = seed;
            this.maxTokens = maxTokens;
            this.topP = topP;
            this.topK = topK;
            this.repetitionPenalty = repetitionPenalty;
            this.temperature = temperature;
            this.stop = stop;
            this.enableSearch = enableSearch;
            this.incrementalOutput = incrementalOutput;
        }

        public Parameters() {
        }

        public static class ParametersBuilder {
            private String resultFormat;
            private Integer seed;
            private Integer maxTokens;
            private Float topP;
            private Float topK;
            private Float repetitionPenalty;
            private Float temperature;
            private List<String> stop;
            private Boolean enableSearch;
            private Boolean incrementalOutput;

            ParametersBuilder() {
            }

            @JsonProperty(value="result_format")
            public ParametersBuilder resultFormat(String resultFormat) {
                this.resultFormat = resultFormat;
                return this;
            }

            public ParametersBuilder seed(Integer seed) {
                this.seed = seed;
                return this;
            }

            @JsonProperty(value="max_tokens")
            public ParametersBuilder maxTokens(Integer maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            @JsonProperty(value="top_p")
            public ParametersBuilder topP(Float topP) {
                this.topP = topP;
                return this;
            }

            @JsonProperty(value="top_k")
            public ParametersBuilder topK(Float topK) {
                this.topK = topK;
                return this;
            }

            @JsonProperty(value="repetition_penalty")
            public ParametersBuilder repetitionPenalty(Float repetitionPenalty) {
                this.repetitionPenalty = repetitionPenalty;
                return this;
            }

            public ParametersBuilder temperature(Float temperature) {
                this.temperature = temperature;
                return this;
            }

            public ParametersBuilder stop(List<String> stop) {
                this.stop = stop;
                return this;
            }

            @JsonProperty(value="enable_search")
            public ParametersBuilder enableSearch(Boolean enableSearch) {
                this.enableSearch = enableSearch;
                return this;
            }

            @JsonProperty(value="incremental_output")
            public ParametersBuilder incrementalOutput(Boolean incrementalOutput) {
                this.incrementalOutput = incrementalOutput;
                return this;
            }

            public Parameters build() {
                return new Parameters(this.resultFormat, this.seed, this.maxTokens, this.topP, this.topK, this.repetitionPenalty, this.temperature, this.stop, this.enableSearch, this.incrementalOutput);
            }

            public String toString() {
                return "AliModelCompletionRequest.Parameters.ParametersBuilder(resultFormat=" + this.resultFormat + ", seed=" + this.seed + ", maxTokens=" + this.maxTokens + ", topP=" + this.topP + ", topK=" + this.topK + ", repetitionPenalty=" + this.repetitionPenalty + ", temperature=" + this.temperature + ", stop=" + this.stop + ", enableSearch=" + this.enableSearch + ", incrementalOutput=" + this.incrementalOutput + ")";
            }
        }
    }
}

