/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.google;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.google.config.PalmConfig;
import cn.bugstack.openai.executor.model.google.valobj.Candidate;
import cn.bugstack.openai.executor.model.google.valobj.PalmCompletionRequest;
import cn.bugstack.openai.executor.model.google.valobj.PalmCompletionResponse;
import cn.bugstack.openai.executor.model.google.valobj.PalmMessage;
import cn.bugstack.openai.executor.model.google.valobj.PalmPrompt;
import cn.bugstack.openai.executor.model.google.valobj.Role;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.Message;
import cn.bugstack.openai.executor.parameter.ParameterHandler;
import cn.bugstack.openai.executor.result.ResultHandler;
import cn.bugstack.openai.session.Configuration;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PalmModelExecutor
implements Executor,
ParameterHandler<PalmCompletionRequest>,
ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(PalmModelExecutor.class);
    private final PalmConfig palmConfig;
    private final OkHttpClient okHttpClient;

    public PalmModelExecutor(Configuration configuration) {
        this.palmConfig = configuration.getPalmConfig();
        this.okHttpClient = configuration.getOkHttpClient();
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        return this.completions(null, null, completionRequest, eventSourceListener);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        String apiHost = null == apiHostByUser ? this.palmConfig.getApiHost() : apiHostByUser;
        String apiKey = this.palmConfig.getApiKey();
        if (apiKeyByUser != null) {
            String[] apiKeySecret = apiKeyByUser.split("\\.");
            log.info(apiKeyByUser);
            apiKey = apiKeySecret[0];
        }
        PalmCompletionRequest palmCompletionRequest = this.getParameterObject(completionRequest);
        final Request request = new Request.Builder().addHeader("Content-Type", "application/json").url(apiHost.concat(this.palmConfig.getV1_completions()).concat(apiKey)).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString((Object)palmCompletionRequest))).build();
        final Call call = this.okHttpClient.newCall(request);
        call.enqueue((Callback)new ResponseCallBack(palmCompletionRequest, eventSourceListener));
        return new EventSource(){

            public Request request() {
                return request;
            }

            public void cancel() {
                call.cancel();
            }
        };
    }

    @Override
    public PalmCompletionRequest getParameterObject(CompletionRequest completionRequest) {
        List<Message> messages = completionRequest.getMessages();
        ArrayList<PalmMessage> palmMessageList = new ArrayList<PalmMessage>(messages.size());
        for (Message message : messages) {
            PalmMessage palmMessage = new PalmMessage();
            palmMessage.setContent(message.getContent());
            if (CompletionRequest.Role.SYSTEM.equals(message.getRole())) {
                palmMessage.setAuthor(Role.SYSTEM.getCode());
            } else if (CompletionRequest.Role.USER.equals(message.getRole())) {
                palmMessage.setAuthor(Role.USER.getCode());
            }
            palmMessageList.add(palmMessage);
        }
        PalmCompletionRequest palmCompletionRequest = new PalmCompletionRequest();
        palmCompletionRequest.setTemperature(completionRequest.getTemperature());
        palmCompletionRequest.setTopP(completionRequest.getTopP());
        PalmPrompt palmPrompt = new PalmPrompt();
        palmPrompt.setMessages(palmMessageList);
        palmCompletionRequest.setPrompt(palmPrompt);
        return palmCompletionRequest;
    }

    @Override
    public EventSourceListener eventSourceListener(EventSourceListener eventSourceListener) {
        return eventSourceListener;
    }

    private static class ResponseCallBack
    implements Callback {
        private final PalmCompletionRequest request;
        private final EventSourceListener eventSourceListener;
        private final EventSource eventSource;

        public ResponseCallBack(PalmCompletionRequest request, EventSourceListener eventSourceListener) {
            this.request = request;
            this.eventSourceListener = eventSourceListener;
            this.eventSource = new EventSource(){

                public Request request() {
                    return this.request();
                }

                public void cancel() {
                    this.cancel();
                }
            };
        }

        public void onFailure(Call call, IOException e) {
            call.cancel();
        }

        public void onResponse(Call call, Response response) throws IOException {
            CompletionResponse completionResponse = new CompletionResponse();
            if (response.isSuccessful()) {
                PalmCompletionResponse palmCompletionResponse = (PalmCompletionResponse)JSON.parseObject((String)response.body().string(), PalmCompletionResponse.class);
                ArrayList<ChatChoice> chatChoices = new ArrayList<ChatChoice>();
                List<Candidate> candidates = palmCompletionResponse.getCandidates();
                for (Candidate candidate : candidates) {
                    ChatChoice chatChoice = new ChatChoice();
                    chatChoice.setDelta(Message.builder().role(CompletionRequest.Role.SYSTEM).name(completionResponse.getModel()).content(candidate.getContent()).build());
                    chatChoices.add(chatChoice);
                }
                completionResponse.setChoices(chatChoices);
            } else {
                ChatChoice chatChoice = new ChatChoice();
                chatChoice.setFinishReason("\u7f51\u7edc\u5f02\u5e38");
                chatChoice.setDelta(new Message());
                completionResponse.setChoices(Collections.singletonList(chatChoice));
            }
            this.eventSourceListener.onEvent(this.eventSource, null, null, JSON.toJSONString((Object)completionResponse));
        }
    }
}

