/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.tencent.valobj;

import cn.bugstack.openai.executor.model.tencent.valobj.Message;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TencentCompletionRequest {
    private static final Logger log = LoggerFactory.getLogger(TencentCompletionRequest.class);
    @JsonProperty(value="Messages")
    private List<Message> messages;
    @JsonProperty(value="TopP")
    private Double topP;
    @JsonProperty(value="Temperature")
    private Double temperature;

    public static TencentCompletionRequestBuilder builder() {
        return new TencentCompletionRequestBuilder();
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    @JsonProperty(value="Messages")
    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    @JsonProperty(value="TopP")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonProperty(value="Temperature")
    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentCompletionRequest)) {
            return false;
        }
        TencentCompletionRequest other = (TencentCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TencentCompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    public String toString() {
        return "TencentCompletionRequest(messages=" + this.getMessages() + ", topP=" + this.getTopP() + ", temperature=" + this.getTemperature() + ")";
    }

    public TencentCompletionRequest() {
    }

    public TencentCompletionRequest(List<Message> messages, Double topP, Double temperature) {
        this.messages = messages;
        this.topP = topP;
        this.temperature = temperature;
    }

    public static class TencentCompletionRequestBuilder {
        private List<Message> messages;
        private Double topP;
        private Double temperature;

        TencentCompletionRequestBuilder() {
        }

        @JsonProperty(value="Messages")
        public TencentCompletionRequestBuilder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        @JsonProperty(value="TopP")
        public TencentCompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @JsonProperty(value="Temperature")
        public TencentCompletionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public TencentCompletionRequest build() {
            return new TencentCompletionRequest(this.messages, this.topP, this.temperature);
        }

        public String toString() {
            return "TencentCompletionRequest.TencentCompletionRequestBuilder(messages=" + this.messages + ", topP=" + this.topP + ", temperature=" + this.temperature + ")";
        }
    }
}

