/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.google;

import cn.bugstack.openai.executor.model.google.PalmModelExecutor;
import cn.bugstack.openai.executor.model.google.config.Const;
import cn.bugstack.openai.executor.model.google.valobj.Role;
import cn.bugstack.openai.executor.model.google.valobj.model.Model;
import cn.bugstack.openai.executor.model.google.valobj.model.PalmModel;
import cn.bugstack.openai.executor.model.google.valobj.request.MessagePrompt;
import cn.bugstack.openai.executor.model.google.valobj.request.PalmChatRequest;
import cn.bugstack.openai.executor.model.google.valobj.request.PalmMessage;
import cn.bugstack.openai.executor.model.google.valobj.response.Candidate;
import cn.bugstack.openai.executor.model.google.valobj.response.PalmCompletionResponse;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.Message;
import cn.bugstack.openai.session.Configuration;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;

public class PalmChatModelExecutor
extends PalmModelExecutor<PalmChatRequest> {
    public PalmChatModelExecutor(Configuration configuration) {
        super(configuration);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        final Request request = this.getRequest(apiHostByUser, apiKeyByUser, completionRequest);
        final Call call = this.getOkHttpClient().newCall(request);
        call.enqueue((Callback)new ResponseCallBack(eventSourceListener));
        return new EventSource(){

            public Request request() {
                return request;
            }

            public void cancel() {
                call.cancel();
            }
        };
    }

    private Request getRequest(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest) throws JsonProcessingException {
        String apiHost = apiHostByUser == null || apiHostByUser.length() == 0 ? this.getPalmConfig().getApiHost() : apiHostByUser;
        String apiKey = apiKeyByUser == null || apiKeyByUser.length() == 0 ? this.getPalmConfig().getApiKey() : apiKeyByUser;
        Model model = PalmModel.getModel(completionRequest.getModel());
        if (model == null) {
            throw new RuntimeException("model must not be null!");
        }
        PalmChatRequest palmChatRequest = this.getParameterObject(completionRequest);
        return new Request.Builder().addHeader("Content-Type", "application/json").url(String.format("%s%s%s:%s?key=%s", apiHost, Const.v2_completions, model.getName(), model.getSupportMethod().getGenerateMethod(), apiKey)).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString((Object)palmChatRequest))).build();
    }

    @Override
    public PalmChatRequest getParameterObject(CompletionRequest completionRequest) {
        List<Message> messages = completionRequest.getMessages();
        ArrayList<PalmMessage> palmMessageList = new ArrayList<PalmMessage>(messages.size());
        for (Message message : messages) {
            PalmMessage palmMessage = new PalmMessage();
            palmMessage.setContent(message.getContent());
            if (CompletionRequest.Role.SYSTEM.equals(message.getRole())) {
                palmMessage.setAuthor(Role.SYSTEM.getCode());
            } else if (CompletionRequest.Role.USER.equals(message.getRole())) {
                palmMessage.setAuthor(Role.USER.getCode());
            }
            palmMessageList.add(palmMessage);
        }
        PalmChatRequest palmChatRequest = new PalmChatRequest();
        palmChatRequest.setTemperature(completionRequest.getTemperature());
        palmChatRequest.setTopP(completionRequest.getTopP());
        MessagePrompt messagePrompt = new MessagePrompt();
        messagePrompt.setMessages(palmMessageList);
        palmChatRequest.setPrompt(messagePrompt);
        return palmChatRequest;
    }

    @Override
    public EventSourceListener eventSourceListener(EventSourceListener eventSourceListener) {
        return eventSourceListener;
    }

    private static class ResponseCallBack
    implements Callback {
        private final EventSourceListener eventSourceListener;

        public ResponseCallBack(EventSourceListener eventSourceListener) {
            this.eventSourceListener = eventSourceListener;
        }

        public void onFailure(Call call, IOException e) {
            call.cancel();
        }

        public void onResponse(Call call, Response response) throws IOException {
            CompletionResponse completionResponse = new CompletionResponse();
            ArrayList<ChatChoice> chatChoices = new ArrayList<ChatChoice>();
            completionResponse.setChoices(chatChoices);
            ResponseBody body = response.body();
            if (response.isSuccessful() && body != null) {
                PalmCompletionResponse palmCompletionResponse = (PalmCompletionResponse)JSON.parseObject((String)body.string(), PalmCompletionResponse.class);
                List<Candidate> candidates = palmCompletionResponse.getCandidates();
                for (Candidate candidate : candidates) {
                    ChatChoice chatChoice = new ChatChoice();
                    chatChoice.setDelta(Message.builder().role(CompletionRequest.Role.SYSTEM).name(completionResponse.getModel()).content(candidate.getContent()).build());
                    chatChoices.add(chatChoice);
                }
                completionResponse.setChoices(chatChoices);
            }
            ChatChoice chatChoice = new ChatChoice();
            chatChoice.setDelta(new Message());
            chatChoice.setFinishReason("stop");
            chatChoices.add(chatChoice);
            this.eventSourceListener.onEvent(new EventSource(){

                public Request request() {
                    return null;
                }

                public void cancel() {
                }
            }, null, null, JSON.toJSONString((Object)completionResponse));
        }
    }
}

