/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.chatglm.valobj;

import cn.bugstack.openai.executor.model.chatglm.valobj.Model;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatGLMCompletionRequest {
    private static final Logger log = LoggerFactory.getLogger(ChatGLMCompletionRequest.class);
    private Model model = Model.CHATGLM_6B_SSE;
    @JsonProperty(value="request_id")
    private String requestId = String.format("xfg-%d", System.currentTimeMillis());
    private double temperature = 0.9;
    @JsonProperty(value="top_p")
    private double topP = 0.7;
    private List<Prompt> prompt;
    private boolean incremental = true;
    private String sseFormat = "data";

    public String toString() {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("request_id", this.requestId);
        paramsMap.put("prompt", this.prompt);
        paramsMap.put("incremental", this.incremental);
        paramsMap.put("temperature", this.temperature);
        paramsMap.put("top_p", this.topP);
        paramsMap.put("sseFormat", this.sseFormat);
        try {
            return new ObjectMapper().writeValueAsString(paramsMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ChatGLMCompletionRequestBuilder builder() {
        return new ChatGLMCompletionRequestBuilder();
    }

    public Model getModel() {
        return this.model;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getTopP() {
        return this.topP;
    }

    public List<Prompt> getPrompt() {
        return this.prompt;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public String getSseFormat() {
        return this.sseFormat;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    @JsonProperty(value="request_id")
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(double topP) {
        this.topP = topP;
    }

    public void setPrompt(List<Prompt> prompt) {
        this.prompt = prompt;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public void setSseFormat(String sseFormat) {
        this.sseFormat = sseFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatGLMCompletionRequest)) {
            return false;
        }
        ChatGLMCompletionRequest other = (ChatGLMCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Double.compare(this.getTopP(), other.getTopP()) != 0) {
            return false;
        }
        if (this.isIncremental() != other.isIncremental()) {
            return false;
        }
        Model this$model = this.getModel();
        Model other$model = other.getModel();
        if (this$model == null ? other$model != null : !((Object)((Object)this$model)).equals((Object)other$model)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        List<Prompt> this$prompt = this.getPrompt();
        List<Prompt> other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !((Object)this$prompt).equals(other$prompt)) {
            return false;
        }
        String this$sseFormat = this.getSseFormat();
        String other$sseFormat = other.getSseFormat();
        return !(this$sseFormat == null ? other$sseFormat != null : !this$sseFormat.equals(other$sseFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatGLMCompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        long $topP = Double.doubleToLongBits(this.getTopP());
        result = result * 59 + (int)($topP >>> 32 ^ $topP);
        result = result * 59 + (this.isIncremental() ? 79 : 97);
        Model $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)((Object)$model)).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        List<Prompt> $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : ((Object)$prompt).hashCode());
        String $sseFormat = this.getSseFormat();
        result = result * 59 + ($sseFormat == null ? 43 : $sseFormat.hashCode());
        return result;
    }

    public ChatGLMCompletionRequest() {
    }

    public ChatGLMCompletionRequest(Model model, String requestId, double temperature, double topP, List<Prompt> prompt, boolean incremental, String sseFormat) {
        this.model = model;
        this.requestId = requestId;
        this.temperature = temperature;
        this.topP = topP;
        this.prompt = prompt;
        this.incremental = incremental;
        this.sseFormat = sseFormat;
    }

    public static class ChatGLMCompletionRequestBuilder {
        private Model model;
        private String requestId;
        private double temperature;
        private double topP;
        private List<Prompt> prompt;
        private boolean incremental;
        private String sseFormat;

        ChatGLMCompletionRequestBuilder() {
        }

        public ChatGLMCompletionRequestBuilder model(Model model) {
            this.model = model;
            return this;
        }

        @JsonProperty(value="request_id")
        public ChatGLMCompletionRequestBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public ChatGLMCompletionRequestBuilder temperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatGLMCompletionRequestBuilder topP(double topP) {
            this.topP = topP;
            return this;
        }

        public ChatGLMCompletionRequestBuilder prompt(List<Prompt> prompt) {
            this.prompt = prompt;
            return this;
        }

        public ChatGLMCompletionRequestBuilder incremental(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        public ChatGLMCompletionRequestBuilder sseFormat(String sseFormat) {
            this.sseFormat = sseFormat;
            return this;
        }

        public ChatGLMCompletionRequest build() {
            return new ChatGLMCompletionRequest(this.model, this.requestId, this.temperature, this.topP, this.prompt, this.incremental, this.sseFormat);
        }

        public String toString() {
            return "ChatGLMCompletionRequest.ChatGLMCompletionRequestBuilder(model=" + (Object)((Object)this.model) + ", requestId=" + this.requestId + ", temperature=" + this.temperature + ", topP=" + this.topP + ", prompt=" + this.prompt + ", incremental=" + this.incremental + ", sseFormat=" + this.sseFormat + ")";
        }
    }

    public static class Prompt {
        private String role;
        private String content;

        public static PromptBuilder builder() {
            return new PromptBuilder();
        }

        public String getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prompt)) {
                return false;
            }
            Prompt other = (Prompt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Prompt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "ChatGLMCompletionRequest.Prompt(role=" + this.getRole() + ", content=" + this.getContent() + ")";
        }

        public Prompt() {
        }

        public Prompt(String role, String content) {
            this.role = role;
            this.content = content;
        }

        public static class PromptBuilder {
            private String role;
            private String content;

            PromptBuilder() {
            }

            public PromptBuilder role(String role) {
                this.role = role;
                return this;
            }

            public PromptBuilder content(String content) {
                this.content = content;
                return this;
            }

            public Prompt build() {
                return new Prompt(this.role, this.content);
            }

            public String toString() {
                return "ChatGLMCompletionRequest.Prompt.PromptBuilder(role=" + this.role + ", content=" + this.content + ")";
            }
        }
    }
}

