/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.google;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.google.config.PalmConfig;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.ParameterHandler;
import cn.bugstack.openai.executor.result.ResultHandler;
import cn.bugstack.openai.session.Configuration;
import okhttp3.OkHttpClient;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PalmModelExecutor<T>
implements Executor,
ParameterHandler<T>,
ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(PalmModelExecutor.class);
    private final PalmConfig palmConfig;
    private final OkHttpClient okHttpClient;
    private final EventSource.Factory factory;

    public PalmModelExecutor(Configuration configuration) {
        this.palmConfig = configuration.getPalmConfig();
        this.okHttpClient = configuration.getOkHttpClient();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        return this.completions(null, null, completionRequest, eventSourceListener);
    }

    public PalmConfig getPalmConfig() {
        return this.palmConfig;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public EventSource.Factory getFactory() {
        return this.factory;
    }
}

