/*
 * Decompiled with CFR 0.152.
 */
package cn.openjava.basic.format.vo;

import cn.hutool.json.JSONUtil;
import cn.openjava.basic.format.message.IMessage;
import cn.openjava.basic.format.message.MessageType;
import cn.openjava.basic.format.message.SystemMessage;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.UUID;
import org.springframework.format.annotation.DateTimeFormat;

public class Result<T> {
    private String uuid;
    private MessageType type;
    private int code;
    private String msg;
    private T data;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date time;
    private int crypto;

    public static <T> Result data(T data) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).code(SystemMessage.SUCCESS.code()).data(data).build();
    }

    public static Result success(IMessage dialog) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(dialog.message()).code(SystemMessage.SUCCESS.code()).type(MessageType.SUCCESS).build();
    }

    public static Result success(String msg) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(msg).code(SystemMessage.SUCCESS.code()).type(MessageType.SUCCESS).build();
    }

    public static <T> Result success(T msg) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(JSONUtil.toJsonStr(msg)).code(SystemMessage.SUCCESS.code()).type(MessageType.SUCCESS).build();
    }

    public static <T> Result success(T data, IMessage dialog) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(dialog.message()).data(data).code(SystemMessage.SUCCESS.code()).type(MessageType.SUCCESS).build();
    }

    public static Result warning(String message) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(message).code(SystemMessage.NORMAL_WARNING.code()).type(MessageType.WARNING).build();
    }

    public static <T> Result success(T data, IMessage dialog, Object ... fillStr) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(MessageFormat.format(dialog.message(), fillStr)).data(data).code(SystemMessage.SUCCESS.code()).type(MessageType.SUCCESS).build();
    }

    public static <T> Result success(T data, int crypto, IMessage dialog, Object ... fillStr) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(MessageFormat.format(dialog.message(), fillStr)).data(data).code(SystemMessage.SUCCESS.code()).crypto(crypto).type(MessageType.SUCCESS).build();
    }

    public static <T> Result info(T data) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).data(data).code(SystemMessage.INFO.code()).type(MessageType.INFO).build();
    }

    public static Result warning(IMessage iDialog) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(iDialog.message()).code(iDialog.code()).type(MessageType.WARNING).build();
    }

    public static Result warning(IMessage iDialog, Object ... fillStr) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(MessageFormat.format(iDialog.message(), fillStr)).code(iDialog.code()).type(MessageType.WARNING).build();
    }

    public static Result warning(String msg, int code) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(msg).code(code).type(MessageType.WARNING).build();
    }

    public static Result error(String exMessage) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(exMessage).code(SystemMessage.EXCEPTION.code()).type(MessageType.ERROR).build();
    }

    public static Result error(IMessage iDialog) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(iDialog.message()).code(iDialog.code()).type(MessageType.ERROR).build();
    }

    public static Result error(IMessage iDialog, Object ... fillStr) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(MessageFormat.format(iDialog.message(), fillStr)).code(iDialog.code()).type(MessageType.ERROR).build();
    }

    public static Result message(IMessage iDialog) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(iDialog.message()).code(iDialog.code()).type(iDialog.type()).build();
    }

    public static Result message(MessageType type, int code, String msg) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(msg).code(code).type(type).build();
    }

    public static Result message(IMessage iDialog, Object ... fillStr) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(MessageFormat.format(iDialog.message(), fillStr)).code(iDialog.code()).type(iDialog.type()).build();
    }

    public static Result error(String eMsg, int code) {
        return Result.builder().uuid(UUID.randomUUID().toString()).time(new Date()).msg(eMsg).code(code).type(MessageType.ERROR).build();
    }

    public Result setType(MessageType type) {
        this.type = type;
        return this;
    }

    public Result setData(T data) {
        this.data = data;
        return this;
    }

    public Result setCrypto(int crypto) {
        this.crypto = crypto;
        return this;
    }

    public Result setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    Result(String uuid, MessageType type, int code, String msg, T data, Date time, int crypto) {
        this.uuid = uuid;
        this.type = type;
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.time = time;
        this.crypto = crypto;
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public MessageType getType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Date getTime() {
        return this.time;
    }

    public int getCrypto() {
        return this.crypto;
    }

    public static class ResultBuilder<T> {
        private String uuid;
        private MessageType type;
        private int code;
        private String msg;
        private T data;
        private Date time;
        private int crypto;

        ResultBuilder() {
        }

        public ResultBuilder<T> uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public ResultBuilder<T> type(MessageType type) {
            this.type = type;
            return this;
        }

        public ResultBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public ResultBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public ResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
        public ResultBuilder<T> time(Date time) {
            this.time = time;
            return this;
        }

        public ResultBuilder<T> crypto(int crypto) {
            this.crypto = crypto;
            return this;
        }

        public Result<T> build() {
            return new Result<T>(this.uuid, this.type, this.code, this.msg, this.data, this.time, this.crypto);
        }

        public String toString() {
            return "Result.ResultBuilder(uuid=" + this.uuid + ", type=" + this.type + ", code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ", time=" + this.time + ", crypto=" + this.crypto + ")";
        }
    }
}

