/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.function.api.dataspecs;

import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.entity.DefaultParamContainer;
import cn.structured.function.api.enums.DataType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;

public class ArrayDataSpecs
implements IDataSpecs {
    private final IDataSpecs subDataSpecs;

    public ArrayDataSpecs(IDataSpecs subDataSpecs) {
        this.subDataSpecs = subDataSpecs;
    }

    @Override
    public DataType getDataType() {
        return DataType.ARRAY;
    }

    @Override
    public Object parse(Object value) {
        JSONArray jsonArray = JSON.parseArray((String)this.toString());
        IDataSpecs subDataSpecs = this.getSubDataSpecs();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object o : jsonArray) {
            DefaultParamContainer container = new DefaultParamContainer(o, subDataSpecs);
            arrayList.add(container.getObject());
        }
        return arrayList;
    }

    @Override
    public boolean validationData(Object value) {
        try {
            JSONArray jsonArray = JSON.parseArray((String)this.toResultString(value));
            for (Object o : jsonArray) {
                if (this.subDataSpecs.validationData(o)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String toResultString(Object value) {
        return JSON.toJSONString((Object)value);
    }

    public IDataSpecs getSubDataSpecs() {
        return this.subDataSpecs;
    }
}

