/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.function.api.dataspecs;

import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.entity.EnumEntity;
import cn.structured.function.api.enums.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumDataSpecs
implements IDataSpecs {
    private Integer startIndex;
    private Map<String, EnumEntity> enumEntities;

    public EnumDataSpecs(List<EnumEntity> enumEntities) {
        DataType dataType = DataType.INT;
        for (EnumEntity enumEntity1 : enumEntities) {
            Object value = enumEntity1.getValue();
            if (!DataType.INT.equals((Object)dataType)) continue;
            try {
                Integer.parseInt(value.toString());
            }
            catch (Exception e) {
                dataType = DataType.TEXT;
            }
        }
        DataType finalDataType = dataType;
        this.enumEntities = new HashMap<String, EnumEntity>();
        for (EnumEntity enumEntity : enumEntities) {
            enumEntity.setDataType(finalDataType);
            this.enumEntities.put(enumEntity.getKey(), enumEntity);
        }
    }

    public EnumDataSpecs(Integer startIndex, List<EnumEntity> enumEntities) {
        this.startIndex = startIndex;
        new EnumDataSpecs(enumEntities);
    }

    public EnumEntity getEnumEntity(String key) {
        return this.enumEntities.get(key);
    }

    public EnumEntity getEnumEntity(Object value) {
        return this.enumEntities.values().stream().filter(enumEntity -> enumEntity.getValue().equals(value)).findFirst().orElse(null);
    }

    @Override
    public DataType getDataType() {
        return DataType.ENUM;
    }

    @Override
    public Object parse(Object value) {
        return this.getEnumEntity(value);
    }

    @Override
    public boolean validationData(Object value) {
        boolean equals = false;
        for (EnumEntity enumEntity : this.enumEntities.values()) {
            if (!enumEntity.getValue().equals(value)) continue;
            equals = true;
            break;
        }
        return equals;
    }

    @Override
    public String toResultString(Object value) {
        return value.toString();
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public List<EnumEntity> getEnumEntities() {
        return new ArrayList<EnumEntity>(this.enumEntities.values());
    }
}

