/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.function.api.dataspecs;

import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.enums.DataType;

public class IntegerDataSpecs
implements IDataSpecs {
    private static final int MAX_LENGTH = 11;
    private int length;

    public IntegerDataSpecs() {
        this.length = 11;
    }

    public IntegerDataSpecs(Integer length) {
        this.setLength(length);
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = Math.min(length, 11);
    }

    @Override
    public DataType getDataType() {
        return DataType.INT;
    }

    @Override
    public Object parse(Object value) {
        return Integer.parseInt(value.toString());
    }

    @Override
    public boolean validationData(Object value) {
        String valueStr = this.toResultString(value);
        try {
            Integer.parseInt(valueStr);
        }
        catch (Exception e) {
            return false;
        }
        return valueStr.length() <= this.length;
    }

    @Override
    public String toResultString(Object value) {
        return value.toString();
    }
}

