package cn.structured.function.example;

import cn.structured.function.api.dataspecs.IntegerDataSpecs;
import cn.structured.function.api.dataspecs.TextDataSpecs;
import cn.structured.function.api.entity.ParamEntity;
import cn.structured.function.api.entity.ScriptFunction;
import cn.structured.function.api.entity.ScriptParams;
import cn.structured.function.core.handler.LuaHandler;
import cn.structured.function.core.handler.ScriptHandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * create by chuck 2024/2/4
 *
 * @author chuck
 * @since JDK1.8
 */
public class TestLuaExecute {
    public static void main(String[] args) {
        // 加载并运行Lua文件或字符串
        String script = "function addNumbers(x, y)\n" +
                "   return x + y\n" +
                "end";
        //构建参数
        ScriptParams params = new ScriptParams();

        //代码片段
        params.setCode(script);

        //构建函数执行参数
        ScriptFunction function = new ScriptFunction();
        function.setFunctionName("addNumbers");


        ParamEntity inputStr1 = new ParamEntity();
        inputStr1.setIdentifier("str1");
        inputStr1.setName("str1");
        inputStr1.setDataSpecs(new IntegerDataSpecs());

        ParamEntity inputStr2 = new ParamEntity();
        inputStr2.setIdentifier("str2");
        inputStr2.setName("str2");
        inputStr2.setDataSpecs(new IntegerDataSpecs());

        List<ParamEntity> inputParams = new ArrayList<>();
        inputParams.add(inputStr1);
        inputParams.add(inputStr2);
        function.setInputParams(inputParams);

        Map<String, Object> inputValues = new HashMap<>();
        inputValues.put("str1", "10");
        inputValues.put("str2", "1");
        function.setInputValues(inputValues);

        //出参定义
        ParamEntity output = new ParamEntity();
        output.setDataSpecs(new TextDataSpecs(200));
        function.setOutputParams(output);

        //赋值函数定义
        params.setFunction(function);

        //构建处理器
        ScriptHandler handler = new LuaHandler();

        //前置定义出参为String.class
        Object result = handler.handler(params);

        //强制转换出参
        System.out.println("result = " + result);
    }
}
