package cn.structured.function.example;

import cn.structured.function.api.dataspecs.IntegerDataSpecs;
import cn.structured.function.api.dataspecs.TextDataSpecs;
import cn.structured.function.api.entity.ParamEntity;
import cn.structured.function.api.entity.ScriptFunction;
import cn.structured.function.api.entity.ScriptParams;
import cn.structured.function.core.handler.PythonHandler;

import java.util.*;

/**
 * @author cqliut
 * @version 2023.0907
 * @since 1.0.1
 */
public class TestPythonHandler {
    public static void main(String[] args) {


        String pythonCode = "# coding=utf-8\n" +
                "import sys\n" +
                "def run(param1,param2):\n" +
                "     return param1 + param2;\n" +
                "";

        //构建python参数
        ScriptParams pythonParams = new ScriptParams();

        //python 执行环境
        Properties props = new Properties();
        props.put("python.home", "path to the Lib folder");
        props.put("python.console.encoding", "UTF-8");
        props.put("python.security.respectJavaAccessibility", "false");
        props.put("python.import.site", "false");
        pythonParams.setProps(props);

        //python代码片段
        pythonParams.setCode(pythonCode);

        //构建函数执行参数
        ScriptFunction pythonFunction = new ScriptFunction();
        pythonFunction.setFunctionName("run");


        ParamEntity inputStr1 = new ParamEntity();
        inputStr1.setIdentifier("str1");
        inputStr1.setName("str1");
        inputStr1.setDataSpecs(new IntegerDataSpecs());

        ParamEntity inputStr2 = new ParamEntity();
        inputStr2.setIdentifier("str2");
        inputStr2.setName("str2");
        inputStr2.setDataSpecs(new IntegerDataSpecs());

        List<ParamEntity> inputParams = new ArrayList<>();
        inputParams.add(inputStr1);
        inputParams.add(inputStr2);
        pythonFunction.setInputParams(inputParams);

        Map<String, Object> inputValues = new HashMap<>();
        inputValues.put("str1", "1");
        inputValues.put("str2", "1");
        pythonFunction.setInputValues(inputValues);

        //出参定义
        ParamEntity output = new ParamEntity();
        output.setDataSpecs(new TextDataSpecs(200));
        pythonFunction.setOutputParams(output);

        //赋值函数定义
        pythonParams.setFunction(pythonFunction);

        //构建处理器
        PythonHandler pythonHandler = new PythonHandler();

        //前置定义出参为String.class
        Object handler = pythonHandler.handler(pythonParams);

        for (int i = 0; i < 1; i++) {

            //强制转换出参
            String result = (String) handler;

            System.out.println("result = " + result);
        }

    }
}
