/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class CodeMoneyUtils {
    private static final String[] CN_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_NUMBER_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final int TEN = 10;
    private static final String CN_ZERO_YUAN = "\u96f6\u5143\u6574";

    public static BigDecimal getFen2Yuan(Integer fen) {
        BigDecimal d = new BigDecimal(fen).divide(new BigDecimal(100));
        return d;
    }

    private static String getYuan(BigDecimal number) {
        DecimalFormat df = new DecimalFormat("0.00");
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format(number);
    }

    public static String getFen2YuanString(Integer fen) {
        return CodeMoneyUtils.getYuan(CodeMoneyUtils.getFen2Yuan(fen));
    }

    public static String convert2CnMoney(BigDecimal yuan) {
        StringBuilder sb = new StringBuilder();
        int signal = yuan.signum();
        if (signal == 0) {
            return CN_ZERO_YUAN;
        }
        long number = yuan.movePointRight(2).setScale(0, RoundingMode.HALF_UP).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_NUMBER_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_NUMBER_UNIT[10]);
                }
                sb.insert(0, CN_NUMBER_UNIT[numIndex]);
                sb.insert(0, CN_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        sb.insert(0, CN_NUMBER_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_NUMBER_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signal == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        if (scale <= 0L) {
            sb.append(CN_FULL);
        }
        return sb.toString();
    }
}

